/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.BrowserLanguage;
import com.google.ads.admanager.v1.BrowserLanguageServiceClient;
import com.google.ads.admanager.v1.GetBrowserLanguageRequest;
import com.google.ads.admanager.v1.ListBrowserLanguagesRequest;
import com.google.ads.admanager.v1.ListBrowserLanguagesResponse;
import com.google.ads.admanager.v1.stub.BrowserLanguageServiceStub;
import com.google.ads.admanager.v1.stub.BrowserLanguageServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonBrowserLanguageServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonBrowserLanguageServiceStub
extends BrowserLanguageServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetBrowserLanguageRequest, BrowserLanguage> getBrowserLanguageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.BrowserLanguageService/GetBrowserLanguage").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/browserLanguages/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)BrowserLanguage.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse> listBrowserLanguagesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.BrowserLanguageService/ListBrowserLanguages").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/browserLanguages", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBrowserLanguagesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetBrowserLanguageRequest, BrowserLanguage> getBrowserLanguageCallable;
    private final UnaryCallable<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse> listBrowserLanguagesCallable;
    private final UnaryCallable<ListBrowserLanguagesRequest, BrowserLanguageServiceClient.ListBrowserLanguagesPagedResponse> listBrowserLanguagesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonBrowserLanguageServiceStub create(BrowserLanguageServiceStubSettings settings) throws IOException {
        return new HttpJsonBrowserLanguageServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonBrowserLanguageServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonBrowserLanguageServiceStub(BrowserLanguageServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonBrowserLanguageServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonBrowserLanguageServiceStub(BrowserLanguageServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonBrowserLanguageServiceStub(BrowserLanguageServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonBrowserLanguageServiceCallableFactory());
    }

    protected HttpJsonBrowserLanguageServiceStub(BrowserLanguageServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getBrowserLanguageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBrowserLanguageMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listBrowserLanguagesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBrowserLanguagesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getBrowserLanguageCallable = callableFactory.createUnaryCallable(getBrowserLanguageTransportSettings, settings.getBrowserLanguageSettings(), clientContext);
        this.listBrowserLanguagesCallable = callableFactory.createUnaryCallable(listBrowserLanguagesTransportSettings, settings.listBrowserLanguagesSettings(), clientContext);
        this.listBrowserLanguagesPagedCallable = callableFactory.createPagedCallable(listBrowserLanguagesTransportSettings, settings.listBrowserLanguagesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getBrowserLanguageMethodDescriptor);
        methodDescriptors.add(listBrowserLanguagesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetBrowserLanguageRequest, BrowserLanguage> getBrowserLanguageCallable() {
        return this.getBrowserLanguageCallable;
    }

    @Override
    public UnaryCallable<ListBrowserLanguagesRequest, ListBrowserLanguagesResponse> listBrowserLanguagesCallable() {
        return this.listBrowserLanguagesCallable;
    }

    @Override
    public UnaryCallable<ListBrowserLanguagesRequest, BrowserLanguageServiceClient.ListBrowserLanguagesPagedResponse> listBrowserLanguagesPagedCallable() {
        return this.listBrowserLanguagesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

