/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CmsMetadataValue;
import com.google.ads.admanager.v1.CmsMetadataValueServiceClient;
import com.google.ads.admanager.v1.GetCmsMetadataValueRequest;
import com.google.ads.admanager.v1.ListCmsMetadataValuesRequest;
import com.google.ads.admanager.v1.ListCmsMetadataValuesResponse;
import com.google.ads.admanager.v1.stub.CmsMetadataValueServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonCmsMetadataValueServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CmsMetadataValueServiceStubSettings
extends StubSettings<CmsMetadataValueServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetCmsMetadataValueRequest, CmsMetadataValue> getCmsMetadataValueSettings;
    private final PagedCallSettings<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValueServiceClient.ListCmsMetadataValuesPagedResponse> listCmsMetadataValuesSettings;
    private static final PagedListDescriptor<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValue> LIST_CMS_METADATA_VALUES_PAGE_STR_DESC = new PagedListDescriptor<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValue>(){

        public String emptyToken() {
            return "";
        }

        public ListCmsMetadataValuesRequest injectToken(ListCmsMetadataValuesRequest payload, String token) {
            return ListCmsMetadataValuesRequest.newBuilder((ListCmsMetadataValuesRequest)payload).setPageToken(token).build();
        }

        public ListCmsMetadataValuesRequest injectPageSize(ListCmsMetadataValuesRequest payload, int pageSize) {
            return ListCmsMetadataValuesRequest.newBuilder((ListCmsMetadataValuesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCmsMetadataValuesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCmsMetadataValuesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CmsMetadataValue> extractResources(ListCmsMetadataValuesResponse payload) {
            return payload.getCmsMetadataValuesList();
        }
    };
    private static final PagedListResponseFactory<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValueServiceClient.ListCmsMetadataValuesPagedResponse> LIST_CMS_METADATA_VALUES_PAGE_STR_FACT = new PagedListResponseFactory<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValueServiceClient.ListCmsMetadataValuesPagedResponse>(){

        public ApiFuture<CmsMetadataValueServiceClient.ListCmsMetadataValuesPagedResponse> getFuturePagedResponse(UnaryCallable<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse> callable, ListCmsMetadataValuesRequest request, ApiCallContext context, ApiFuture<ListCmsMetadataValuesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CMS_METADATA_VALUES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CmsMetadataValueServiceClient.ListCmsMetadataValuesPagedResponse.createAsync((PageContext<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValue>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetCmsMetadataValueRequest, CmsMetadataValue> getCmsMetadataValueSettings() {
        return this.getCmsMetadataValueSettings;
    }

    public PagedCallSettings<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValueServiceClient.ListCmsMetadataValuesPagedResponse> listCmsMetadataValuesSettings() {
        return this.listCmsMetadataValuesSettings;
    }

    public CmsMetadataValueServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCmsMetadataValueServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CmsMetadataValueServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CmsMetadataValueServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CmsMetadataValueServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCmsMetadataValueSettings = settingsBuilder.getCmsMetadataValueSettings().build();
        this.listCmsMetadataValuesSettings = settingsBuilder.listCmsMetadataValuesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CmsMetadataValueServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCmsMetadataValueRequest, CmsMetadataValue> getCmsMetadataValueSettings;
        private final PagedCallSettings.Builder<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValueServiceClient.ListCmsMetadataValuesPagedResponse> listCmsMetadataValuesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCmsMetadataValueSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCmsMetadataValuesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CMS_METADATA_VALUES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCmsMetadataValueSettings, this.listCmsMetadataValuesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CmsMetadataValueServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCmsMetadataValueSettings = settings.getCmsMetadataValueSettings.toBuilder();
            this.listCmsMetadataValuesSettings = settings.listCmsMetadataValuesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCmsMetadataValueSettings, this.listCmsMetadataValuesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CmsMetadataValueServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CmsMetadataValueServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CmsMetadataValueServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CmsMetadataValueServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCmsMetadataValueSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listCmsMetadataValuesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCmsMetadataValueRequest, CmsMetadataValue> getCmsMetadataValueSettings() {
            return this.getCmsMetadataValueSettings;
        }

        public PagedCallSettings.Builder<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValueServiceClient.ListCmsMetadataValuesPagedResponse> listCmsMetadataValuesSettings() {
            return this.listCmsMetadataValuesSettings;
        }

        public CmsMetadataValueServiceStubSettings build() throws IOException {
            return new CmsMetadataValueServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

