/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CmsMetadataKey;
import com.google.ads.admanager.v1.CmsMetadataKeyServiceClient;
import com.google.ads.admanager.v1.GetCmsMetadataKeyRequest;
import com.google.ads.admanager.v1.ListCmsMetadataKeysRequest;
import com.google.ads.admanager.v1.ListCmsMetadataKeysResponse;
import com.google.ads.admanager.v1.stub.CmsMetadataKeyServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonCmsMetadataKeyServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CmsMetadataKeyServiceStubSettings
extends StubSettings<CmsMetadataKeyServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetCmsMetadataKeyRequest, CmsMetadataKey> getCmsMetadataKeySettings;
    private final PagedCallSettings<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKeyServiceClient.ListCmsMetadataKeysPagedResponse> listCmsMetadataKeysSettings;
    private static final PagedListDescriptor<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKey> LIST_CMS_METADATA_KEYS_PAGE_STR_DESC = new PagedListDescriptor<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKey>(){

        public String emptyToken() {
            return "";
        }

        public ListCmsMetadataKeysRequest injectToken(ListCmsMetadataKeysRequest payload, String token) {
            return ListCmsMetadataKeysRequest.newBuilder((ListCmsMetadataKeysRequest)payload).setPageToken(token).build();
        }

        public ListCmsMetadataKeysRequest injectPageSize(ListCmsMetadataKeysRequest payload, int pageSize) {
            return ListCmsMetadataKeysRequest.newBuilder((ListCmsMetadataKeysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCmsMetadataKeysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCmsMetadataKeysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CmsMetadataKey> extractResources(ListCmsMetadataKeysResponse payload) {
            return payload.getCmsMetadataKeysList();
        }
    };
    private static final PagedListResponseFactory<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKeyServiceClient.ListCmsMetadataKeysPagedResponse> LIST_CMS_METADATA_KEYS_PAGE_STR_FACT = new PagedListResponseFactory<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKeyServiceClient.ListCmsMetadataKeysPagedResponse>(){

        public ApiFuture<CmsMetadataKeyServiceClient.ListCmsMetadataKeysPagedResponse> getFuturePagedResponse(UnaryCallable<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse> callable, ListCmsMetadataKeysRequest request, ApiCallContext context, ApiFuture<ListCmsMetadataKeysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CMS_METADATA_KEYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CmsMetadataKeyServiceClient.ListCmsMetadataKeysPagedResponse.createAsync((PageContext<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKey>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetCmsMetadataKeyRequest, CmsMetadataKey> getCmsMetadataKeySettings() {
        return this.getCmsMetadataKeySettings;
    }

    public PagedCallSettings<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKeyServiceClient.ListCmsMetadataKeysPagedResponse> listCmsMetadataKeysSettings() {
        return this.listCmsMetadataKeysSettings;
    }

    public CmsMetadataKeyServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCmsMetadataKeyServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CmsMetadataKeyServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CmsMetadataKeyServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CmsMetadataKeyServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getCmsMetadataKeySettings = settingsBuilder.getCmsMetadataKeySettings().build();
        this.listCmsMetadataKeysSettings = settingsBuilder.listCmsMetadataKeysSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CmsMetadataKeyServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetCmsMetadataKeyRequest, CmsMetadataKey> getCmsMetadataKeySettings;
        private final PagedCallSettings.Builder<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKeyServiceClient.ListCmsMetadataKeysPagedResponse> listCmsMetadataKeysSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getCmsMetadataKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCmsMetadataKeysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CMS_METADATA_KEYS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCmsMetadataKeySettings, this.listCmsMetadataKeysSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CmsMetadataKeyServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getCmsMetadataKeySettings = settings.getCmsMetadataKeySettings.toBuilder();
            this.listCmsMetadataKeysSettings = settings.listCmsMetadataKeysSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getCmsMetadataKeySettings, this.listCmsMetadataKeysSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CmsMetadataKeyServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CmsMetadataKeyServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CmsMetadataKeyServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CmsMetadataKeyServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getCmsMetadataKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listCmsMetadataKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetCmsMetadataKeyRequest, CmsMetadataKey> getCmsMetadataKeySettings() {
            return this.getCmsMetadataKeySettings;
        }

        public PagedCallSettings.Builder<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKeyServiceClient.ListCmsMetadataKeysPagedResponse> listCmsMetadataKeysSettings() {
            return this.listCmsMetadataKeysSettings;
        }

        public CmsMetadataKeyServiceStubSettings build() throws IOException {
            return new CmsMetadataKeyServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

