/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.AdReviewCenterAd;
import com.google.ads.admanager.v1.AdReviewCenterAdServiceClient;
import com.google.ads.admanager.v1.BatchAdReviewCenterAdsOperationMetadata;
import com.google.ads.admanager.v1.BatchAllowAdReviewCenterAdsRequest;
import com.google.ads.admanager.v1.BatchAllowAdReviewCenterAdsResponse;
import com.google.ads.admanager.v1.BatchBlockAdReviewCenterAdsRequest;
import com.google.ads.admanager.v1.BatchBlockAdReviewCenterAdsResponse;
import com.google.ads.admanager.v1.SearchAdReviewCenterAdsRequest;
import com.google.ads.admanager.v1.SearchAdReviewCenterAdsResponse;
import com.google.ads.admanager.v1.stub.AdReviewCenterAdServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonAdReviewCenterAdServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class AdReviewCenterAdServiceStubSettings
extends StubSettings<AdReviewCenterAdServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final PagedCallSettings<SearchAdReviewCenterAdsRequest, SearchAdReviewCenterAdsResponse, AdReviewCenterAdServiceClient.SearchAdReviewCenterAdsPagedResponse> searchAdReviewCenterAdsSettings;
    private final UnaryCallSettings<BatchAllowAdReviewCenterAdsRequest, Operation> batchAllowAdReviewCenterAdsSettings;
    private final OperationCallSettings<BatchAllowAdReviewCenterAdsRequest, BatchAllowAdReviewCenterAdsResponse, BatchAdReviewCenterAdsOperationMetadata> batchAllowAdReviewCenterAdsOperationSettings;
    private final UnaryCallSettings<BatchBlockAdReviewCenterAdsRequest, Operation> batchBlockAdReviewCenterAdsSettings;
    private final OperationCallSettings<BatchBlockAdReviewCenterAdsRequest, BatchBlockAdReviewCenterAdsResponse, BatchAdReviewCenterAdsOperationMetadata> batchBlockAdReviewCenterAdsOperationSettings;
    private static final PagedListDescriptor<SearchAdReviewCenterAdsRequest, SearchAdReviewCenterAdsResponse, AdReviewCenterAd> SEARCH_AD_REVIEW_CENTER_ADS_PAGE_STR_DESC = new PagedListDescriptor<SearchAdReviewCenterAdsRequest, SearchAdReviewCenterAdsResponse, AdReviewCenterAd>(){

        public String emptyToken() {
            return "";
        }

        public SearchAdReviewCenterAdsRequest injectToken(SearchAdReviewCenterAdsRequest payload, String token) {
            return SearchAdReviewCenterAdsRequest.newBuilder((SearchAdReviewCenterAdsRequest)payload).setPageToken(token).build();
        }

        public SearchAdReviewCenterAdsRequest injectPageSize(SearchAdReviewCenterAdsRequest payload, int pageSize) {
            return SearchAdReviewCenterAdsRequest.newBuilder((SearchAdReviewCenterAdsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchAdReviewCenterAdsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchAdReviewCenterAdsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AdReviewCenterAd> extractResources(SearchAdReviewCenterAdsResponse payload) {
            return payload.getAdReviewCenterAdsList();
        }
    };
    private static final PagedListResponseFactory<SearchAdReviewCenterAdsRequest, SearchAdReviewCenterAdsResponse, AdReviewCenterAdServiceClient.SearchAdReviewCenterAdsPagedResponse> SEARCH_AD_REVIEW_CENTER_ADS_PAGE_STR_FACT = new PagedListResponseFactory<SearchAdReviewCenterAdsRequest, SearchAdReviewCenterAdsResponse, AdReviewCenterAdServiceClient.SearchAdReviewCenterAdsPagedResponse>(){

        public ApiFuture<AdReviewCenterAdServiceClient.SearchAdReviewCenterAdsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchAdReviewCenterAdsRequest, SearchAdReviewCenterAdsResponse> callable, SearchAdReviewCenterAdsRequest request, ApiCallContext context, ApiFuture<SearchAdReviewCenterAdsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_AD_REVIEW_CENTER_ADS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AdReviewCenterAdServiceClient.SearchAdReviewCenterAdsPagedResponse.createAsync((PageContext<SearchAdReviewCenterAdsRequest, SearchAdReviewCenterAdsResponse, AdReviewCenterAd>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<SearchAdReviewCenterAdsRequest, SearchAdReviewCenterAdsResponse, AdReviewCenterAdServiceClient.SearchAdReviewCenterAdsPagedResponse> searchAdReviewCenterAdsSettings() {
        return this.searchAdReviewCenterAdsSettings;
    }

    public UnaryCallSettings<BatchAllowAdReviewCenterAdsRequest, Operation> batchAllowAdReviewCenterAdsSettings() {
        return this.batchAllowAdReviewCenterAdsSettings;
    }

    public OperationCallSettings<BatchAllowAdReviewCenterAdsRequest, BatchAllowAdReviewCenterAdsResponse, BatchAdReviewCenterAdsOperationMetadata> batchAllowAdReviewCenterAdsOperationSettings() {
        return this.batchAllowAdReviewCenterAdsOperationSettings;
    }

    public UnaryCallSettings<BatchBlockAdReviewCenterAdsRequest, Operation> batchBlockAdReviewCenterAdsSettings() {
        return this.batchBlockAdReviewCenterAdsSettings;
    }

    public OperationCallSettings<BatchBlockAdReviewCenterAdsRequest, BatchBlockAdReviewCenterAdsResponse, BatchAdReviewCenterAdsOperationMetadata> batchBlockAdReviewCenterAdsOperationSettings() {
        return this.batchBlockAdReviewCenterAdsOperationSettings;
    }

    public AdReviewCenterAdServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAdReviewCenterAdServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AdReviewCenterAdServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AdReviewCenterAdServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AdReviewCenterAdServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.searchAdReviewCenterAdsSettings = settingsBuilder.searchAdReviewCenterAdsSettings().build();
        this.batchAllowAdReviewCenterAdsSettings = settingsBuilder.batchAllowAdReviewCenterAdsSettings().build();
        this.batchAllowAdReviewCenterAdsOperationSettings = settingsBuilder.batchAllowAdReviewCenterAdsOperationSettings().build();
        this.batchBlockAdReviewCenterAdsSettings = settingsBuilder.batchBlockAdReviewCenterAdsSettings().build();
        this.batchBlockAdReviewCenterAdsOperationSettings = settingsBuilder.batchBlockAdReviewCenterAdsOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AdReviewCenterAdServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<SearchAdReviewCenterAdsRequest, SearchAdReviewCenterAdsResponse, AdReviewCenterAdServiceClient.SearchAdReviewCenterAdsPagedResponse> searchAdReviewCenterAdsSettings;
        private final UnaryCallSettings.Builder<BatchAllowAdReviewCenterAdsRequest, Operation> batchAllowAdReviewCenterAdsSettings;
        private final OperationCallSettings.Builder<BatchAllowAdReviewCenterAdsRequest, BatchAllowAdReviewCenterAdsResponse, BatchAdReviewCenterAdsOperationMetadata> batchAllowAdReviewCenterAdsOperationSettings;
        private final UnaryCallSettings.Builder<BatchBlockAdReviewCenterAdsRequest, Operation> batchBlockAdReviewCenterAdsSettings;
        private final OperationCallSettings.Builder<BatchBlockAdReviewCenterAdsRequest, BatchBlockAdReviewCenterAdsResponse, BatchAdReviewCenterAdsOperationMetadata> batchBlockAdReviewCenterAdsOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.searchAdReviewCenterAdsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_AD_REVIEW_CENTER_ADS_PAGE_STR_FACT);
            this.batchAllowAdReviewCenterAdsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchAllowAdReviewCenterAdsOperationSettings = OperationCallSettings.newBuilder();
            this.batchBlockAdReviewCenterAdsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchBlockAdReviewCenterAdsOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchAdReviewCenterAdsSettings, this.batchAllowAdReviewCenterAdsSettings, this.batchBlockAdReviewCenterAdsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AdReviewCenterAdServiceStubSettings settings) {
            super((StubSettings)settings);
            this.searchAdReviewCenterAdsSettings = settings.searchAdReviewCenterAdsSettings.toBuilder();
            this.batchAllowAdReviewCenterAdsSettings = settings.batchAllowAdReviewCenterAdsSettings.toBuilder();
            this.batchAllowAdReviewCenterAdsOperationSettings = settings.batchAllowAdReviewCenterAdsOperationSettings.toBuilder();
            this.batchBlockAdReviewCenterAdsSettings = settings.batchBlockAdReviewCenterAdsSettings.toBuilder();
            this.batchBlockAdReviewCenterAdsOperationSettings = settings.batchBlockAdReviewCenterAdsOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchAdReviewCenterAdsSettings, this.batchAllowAdReviewCenterAdsSettings, this.batchBlockAdReviewCenterAdsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AdReviewCenterAdServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AdReviewCenterAdServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AdReviewCenterAdServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AdReviewCenterAdServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.searchAdReviewCenterAdsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchAllowAdReviewCenterAdsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchBlockAdReviewCenterAdsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.batchAllowAdReviewCenterAdsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchAllowAdReviewCenterAdsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchAdReviewCenterAdsOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.batchBlockAdReviewCenterAdsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchBlockAdReviewCenterAdsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchAdReviewCenterAdsOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<SearchAdReviewCenterAdsRequest, SearchAdReviewCenterAdsResponse, AdReviewCenterAdServiceClient.SearchAdReviewCenterAdsPagedResponse> searchAdReviewCenterAdsSettings() {
            return this.searchAdReviewCenterAdsSettings;
        }

        public UnaryCallSettings.Builder<BatchAllowAdReviewCenterAdsRequest, Operation> batchAllowAdReviewCenterAdsSettings() {
            return this.batchAllowAdReviewCenterAdsSettings;
        }

        public OperationCallSettings.Builder<BatchAllowAdReviewCenterAdsRequest, BatchAllowAdReviewCenterAdsResponse, BatchAdReviewCenterAdsOperationMetadata> batchAllowAdReviewCenterAdsOperationSettings() {
            return this.batchAllowAdReviewCenterAdsOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchBlockAdReviewCenterAdsRequest, Operation> batchBlockAdReviewCenterAdsSettings() {
            return this.batchBlockAdReviewCenterAdsSettings;
        }

        public OperationCallSettings.Builder<BatchBlockAdReviewCenterAdsRequest, BatchBlockAdReviewCenterAdsResponse, BatchAdReviewCenterAdsOperationMetadata> batchBlockAdReviewCenterAdsOperationSettings() {
            return this.batchBlockAdReviewCenterAdsOperationSettings;
        }

        public AdReviewCenterAdServiceStubSettings build() throws IOException {
            return new AdReviewCenterAdServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

