/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetMobileDeviceRequest;
import com.google.ads.admanager.v1.ListMobileDevicesRequest;
import com.google.ads.admanager.v1.ListMobileDevicesResponse;
import com.google.ads.admanager.v1.MobileDevice;
import com.google.ads.admanager.v1.MobileDeviceName;
import com.google.ads.admanager.v1.MobileDeviceServiceSettings;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.MobileDeviceServiceStub;
import com.google.ads.admanager.v1.stub.MobileDeviceServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MobileDeviceServiceClient
implements BackgroundResource {
    private final MobileDeviceServiceSettings settings;
    private final MobileDeviceServiceStub stub;

    public static final MobileDeviceServiceClient create() throws IOException {
        return MobileDeviceServiceClient.create(MobileDeviceServiceSettings.newBuilder().build());
    }

    public static final MobileDeviceServiceClient create(MobileDeviceServiceSettings settings) throws IOException {
        return new MobileDeviceServiceClient(settings);
    }

    public static final MobileDeviceServiceClient create(MobileDeviceServiceStub stub) {
        return new MobileDeviceServiceClient(stub);
    }

    protected MobileDeviceServiceClient(MobileDeviceServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MobileDeviceServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected MobileDeviceServiceClient(MobileDeviceServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MobileDeviceServiceSettings getSettings() {
        return this.settings;
    }

    public MobileDeviceServiceStub getStub() {
        return this.stub;
    }

    public final MobileDevice getMobileDevice(MobileDeviceName name) {
        GetMobileDeviceRequest request = GetMobileDeviceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMobileDevice(request);
    }

    public final MobileDevice getMobileDevice(String name) {
        GetMobileDeviceRequest request = GetMobileDeviceRequest.newBuilder().setName(name).build();
        return this.getMobileDevice(request);
    }

    public final MobileDevice getMobileDevice(GetMobileDeviceRequest request) {
        return (MobileDevice)this.getMobileDeviceCallable().call((Object)request);
    }

    public final UnaryCallable<GetMobileDeviceRequest, MobileDevice> getMobileDeviceCallable() {
        return this.stub.getMobileDeviceCallable();
    }

    public final ListMobileDevicesPagedResponse listMobileDevices(NetworkName parent) {
        ListMobileDevicesRequest request = ListMobileDevicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMobileDevices(request);
    }

    public final ListMobileDevicesPagedResponse listMobileDevices(String parent) {
        ListMobileDevicesRequest request = ListMobileDevicesRequest.newBuilder().setParent(parent).build();
        return this.listMobileDevices(request);
    }

    public final ListMobileDevicesPagedResponse listMobileDevices(ListMobileDevicesRequest request) {
        return (ListMobileDevicesPagedResponse)((Object)this.listMobileDevicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMobileDevicesRequest, ListMobileDevicesPagedResponse> listMobileDevicesPagedCallable() {
        return this.stub.listMobileDevicesPagedCallable();
    }

    public final UnaryCallable<ListMobileDevicesRequest, ListMobileDevicesResponse> listMobileDevicesCallable() {
        return this.stub.listMobileDevicesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListMobileDevicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDevice, ListMobileDevicesPage, ListMobileDevicesFixedSizeCollection> {
        private ListMobileDevicesFixedSizeCollection(List<ListMobileDevicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMobileDevicesFixedSizeCollection createEmptyCollection() {
            return new ListMobileDevicesFixedSizeCollection(null, 0);
        }

        protected ListMobileDevicesFixedSizeCollection createCollection(List<ListMobileDevicesPage> pages, int collectionSize) {
            return new ListMobileDevicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMobileDevicesPage
    extends AbstractPage<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDevice, ListMobileDevicesPage> {
        private ListMobileDevicesPage(PageContext<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDevice> context, ListMobileDevicesResponse response) {
            super(context, (Object)response);
        }

        private static ListMobileDevicesPage createEmptyPage() {
            return new ListMobileDevicesPage(null, null);
        }

        protected ListMobileDevicesPage createPage(PageContext<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDevice> context, ListMobileDevicesResponse response) {
            return new ListMobileDevicesPage(context, response);
        }

        public ApiFuture<ListMobileDevicesPage> createPageAsync(PageContext<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDevice> context, ApiFuture<ListMobileDevicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMobileDevicesPagedResponse
    extends AbstractPagedListResponse<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDevice, ListMobileDevicesPage, ListMobileDevicesFixedSizeCollection> {
        public static ApiFuture<ListMobileDevicesPagedResponse> createAsync(PageContext<ListMobileDevicesRequest, ListMobileDevicesResponse, MobileDevice> context, ApiFuture<ListMobileDevicesResponse> futureResponse) {
            ApiFuture<ListMobileDevicesPage> futurePage = ListMobileDevicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMobileDevicesPagedResponse((ListMobileDevicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMobileDevicesPagedResponse(ListMobileDevicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMobileDevicesFixedSizeCollection.createEmptyCollection());
        }
    }
}

