/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.BatchActivateCustomFieldsRequest;
import com.google.ads.admanager.v1.BatchActivateCustomFieldsResponse;
import com.google.ads.admanager.v1.BatchCreateCustomFieldsRequest;
import com.google.ads.admanager.v1.BatchCreateCustomFieldsResponse;
import com.google.ads.admanager.v1.BatchDeactivateCustomFieldsRequest;
import com.google.ads.admanager.v1.BatchDeactivateCustomFieldsResponse;
import com.google.ads.admanager.v1.BatchUpdateCustomFieldsRequest;
import com.google.ads.admanager.v1.BatchUpdateCustomFieldsResponse;
import com.google.ads.admanager.v1.CreateCustomFieldRequest;
import com.google.ads.admanager.v1.CustomField;
import com.google.ads.admanager.v1.CustomFieldName;
import com.google.ads.admanager.v1.CustomFieldServiceSettings;
import com.google.ads.admanager.v1.GetCustomFieldRequest;
import com.google.ads.admanager.v1.ListCustomFieldsRequest;
import com.google.ads.admanager.v1.ListCustomFieldsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.UpdateCustomFieldRequest;
import com.google.ads.admanager.v1.stub.CustomFieldServiceStub;
import com.google.ads.admanager.v1.stub.CustomFieldServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CustomFieldServiceClient
implements BackgroundResource {
    private final CustomFieldServiceSettings settings;
    private final CustomFieldServiceStub stub;

    public static final CustomFieldServiceClient create() throws IOException {
        return CustomFieldServiceClient.create(CustomFieldServiceSettings.newBuilder().build());
    }

    public static final CustomFieldServiceClient create(CustomFieldServiceSettings settings) throws IOException {
        return new CustomFieldServiceClient(settings);
    }

    public static final CustomFieldServiceClient create(CustomFieldServiceStub stub) {
        return new CustomFieldServiceClient(stub);
    }

    protected CustomFieldServiceClient(CustomFieldServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomFieldServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomFieldServiceClient(CustomFieldServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomFieldServiceSettings getSettings() {
        return this.settings;
    }

    public CustomFieldServiceStub getStub() {
        return this.stub;
    }

    public final CustomField getCustomField(CustomFieldName name) {
        GetCustomFieldRequest request = GetCustomFieldRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomField(request);
    }

    public final CustomField getCustomField(String name) {
        GetCustomFieldRequest request = GetCustomFieldRequest.newBuilder().setName(name).build();
        return this.getCustomField(request);
    }

    public final CustomField getCustomField(GetCustomFieldRequest request) {
        return (CustomField)this.getCustomFieldCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomFieldRequest, CustomField> getCustomFieldCallable() {
        return this.stub.getCustomFieldCallable();
    }

    public final ListCustomFieldsPagedResponse listCustomFields(NetworkName parent) {
        ListCustomFieldsRequest request = ListCustomFieldsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCustomFields(request);
    }

    public final ListCustomFieldsPagedResponse listCustomFields(String parent) {
        ListCustomFieldsRequest request = ListCustomFieldsRequest.newBuilder().setParent(parent).build();
        return this.listCustomFields(request);
    }

    public final ListCustomFieldsPagedResponse listCustomFields(ListCustomFieldsRequest request) {
        return (ListCustomFieldsPagedResponse)((Object)this.listCustomFieldsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomFieldsRequest, ListCustomFieldsPagedResponse> listCustomFieldsPagedCallable() {
        return this.stub.listCustomFieldsPagedCallable();
    }

    public final UnaryCallable<ListCustomFieldsRequest, ListCustomFieldsResponse> listCustomFieldsCallable() {
        return this.stub.listCustomFieldsCallable();
    }

    public final CustomField createCustomField(NetworkName parent, CustomField customField) {
        CreateCustomFieldRequest request = CreateCustomFieldRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCustomField(customField).build();
        return this.createCustomField(request);
    }

    public final CustomField createCustomField(String parent, CustomField customField) {
        CreateCustomFieldRequest request = CreateCustomFieldRequest.newBuilder().setParent(parent).setCustomField(customField).build();
        return this.createCustomField(request);
    }

    public final CustomField createCustomField(CreateCustomFieldRequest request) {
        return (CustomField)this.createCustomFieldCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCustomFieldRequest, CustomField> createCustomFieldCallable() {
        return this.stub.createCustomFieldCallable();
    }

    public final BatchCreateCustomFieldsResponse batchCreateCustomFields(NetworkName parent, List<CreateCustomFieldRequest> requests) {
        BatchCreateCustomFieldsRequest request = BatchCreateCustomFieldsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchCreateCustomFields(request);
    }

    public final BatchCreateCustomFieldsResponse batchCreateCustomFields(String parent, List<CreateCustomFieldRequest> requests) {
        BatchCreateCustomFieldsRequest request = BatchCreateCustomFieldsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchCreateCustomFields(request);
    }

    public final BatchCreateCustomFieldsResponse batchCreateCustomFields(BatchCreateCustomFieldsRequest request) {
        return (BatchCreateCustomFieldsResponse)this.batchCreateCustomFieldsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateCustomFieldsRequest, BatchCreateCustomFieldsResponse> batchCreateCustomFieldsCallable() {
        return this.stub.batchCreateCustomFieldsCallable();
    }

    public final CustomField updateCustomField(CustomField customField, FieldMask updateMask) {
        UpdateCustomFieldRequest request = UpdateCustomFieldRequest.newBuilder().setCustomField(customField).setUpdateMask(updateMask).build();
        return this.updateCustomField(request);
    }

    public final CustomField updateCustomField(UpdateCustomFieldRequest request) {
        return (CustomField)this.updateCustomFieldCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCustomFieldRequest, CustomField> updateCustomFieldCallable() {
        return this.stub.updateCustomFieldCallable();
    }

    public final BatchUpdateCustomFieldsResponse batchUpdateCustomFields(NetworkName parent, List<UpdateCustomFieldRequest> requests) {
        BatchUpdateCustomFieldsRequest request = BatchUpdateCustomFieldsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchUpdateCustomFields(request);
    }

    public final BatchUpdateCustomFieldsResponse batchUpdateCustomFields(String parent, List<UpdateCustomFieldRequest> requests) {
        BatchUpdateCustomFieldsRequest request = BatchUpdateCustomFieldsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchUpdateCustomFields(request);
    }

    public final BatchUpdateCustomFieldsResponse batchUpdateCustomFields(BatchUpdateCustomFieldsRequest request) {
        return (BatchUpdateCustomFieldsResponse)this.batchUpdateCustomFieldsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchUpdateCustomFieldsRequest, BatchUpdateCustomFieldsResponse> batchUpdateCustomFieldsCallable() {
        return this.stub.batchUpdateCustomFieldsCallable();
    }

    public final BatchActivateCustomFieldsResponse batchActivateCustomFields(NetworkName parent, List<String> names) {
        BatchActivateCustomFieldsRequest request = BatchActivateCustomFieldsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.batchActivateCustomFields(request);
    }

    public final BatchActivateCustomFieldsResponse batchActivateCustomFields(String parent, List<String> names) {
        BatchActivateCustomFieldsRequest request = BatchActivateCustomFieldsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.batchActivateCustomFields(request);
    }

    public final BatchActivateCustomFieldsResponse batchActivateCustomFields(BatchActivateCustomFieldsRequest request) {
        return (BatchActivateCustomFieldsResponse)this.batchActivateCustomFieldsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchActivateCustomFieldsRequest, BatchActivateCustomFieldsResponse> batchActivateCustomFieldsCallable() {
        return this.stub.batchActivateCustomFieldsCallable();
    }

    public final BatchDeactivateCustomFieldsResponse batchDeactivateCustomFields(NetworkName parent, List<String> names) {
        BatchDeactivateCustomFieldsRequest request = BatchDeactivateCustomFieldsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllNames(names).build();
        return this.batchDeactivateCustomFields(request);
    }

    public final BatchDeactivateCustomFieldsResponse batchDeactivateCustomFields(String parent, List<String> names) {
        BatchDeactivateCustomFieldsRequest request = BatchDeactivateCustomFieldsRequest.newBuilder().setParent(parent).addAllNames(names).build();
        return this.batchDeactivateCustomFields(request);
    }

    public final BatchDeactivateCustomFieldsResponse batchDeactivateCustomFields(BatchDeactivateCustomFieldsRequest request) {
        return (BatchDeactivateCustomFieldsResponse)this.batchDeactivateCustomFieldsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchDeactivateCustomFieldsRequest, BatchDeactivateCustomFieldsResponse> batchDeactivateCustomFieldsCallable() {
        return this.stub.batchDeactivateCustomFieldsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCustomFieldsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField, ListCustomFieldsPage, ListCustomFieldsFixedSizeCollection> {
        private ListCustomFieldsFixedSizeCollection(List<ListCustomFieldsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomFieldsFixedSizeCollection createEmptyCollection() {
            return new ListCustomFieldsFixedSizeCollection(null, 0);
        }

        protected ListCustomFieldsFixedSizeCollection createCollection(List<ListCustomFieldsPage> pages, int collectionSize) {
            return new ListCustomFieldsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomFieldsPage
    extends AbstractPage<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField, ListCustomFieldsPage> {
        private ListCustomFieldsPage(PageContext<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField> context, ListCustomFieldsResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomFieldsPage createEmptyPage() {
            return new ListCustomFieldsPage(null, null);
        }

        protected ListCustomFieldsPage createPage(PageContext<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField> context, ListCustomFieldsResponse response) {
            return new ListCustomFieldsPage(context, response);
        }

        public ApiFuture<ListCustomFieldsPage> createPageAsync(PageContext<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField> context, ApiFuture<ListCustomFieldsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomFieldsPagedResponse
    extends AbstractPagedListResponse<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField, ListCustomFieldsPage, ListCustomFieldsFixedSizeCollection> {
        public static ApiFuture<ListCustomFieldsPagedResponse> createAsync(PageContext<ListCustomFieldsRequest, ListCustomFieldsResponse, CustomField> context, ApiFuture<ListCustomFieldsResponse> futureResponse) {
            ApiFuture<ListCustomFieldsPage> futurePage = ListCustomFieldsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomFieldsPagedResponse((ListCustomFieldsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomFieldsPagedResponse(ListCustomFieldsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomFieldsFixedSizeCollection.createEmptyCollection());
        }
    }
}

