/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.CreativeTemplate;
import com.google.ads.admanager.v1.CreativeTemplateName;
import com.google.ads.admanager.v1.CreativeTemplateServiceSettings;
import com.google.ads.admanager.v1.GetCreativeTemplateRequest;
import com.google.ads.admanager.v1.ListCreativeTemplatesRequest;
import com.google.ads.admanager.v1.ListCreativeTemplatesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.CreativeTemplateServiceStub;
import com.google.ads.admanager.v1.stub.CreativeTemplateServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CreativeTemplateServiceClient
implements BackgroundResource {
    private final CreativeTemplateServiceSettings settings;
    private final CreativeTemplateServiceStub stub;

    public static final CreativeTemplateServiceClient create() throws IOException {
        return CreativeTemplateServiceClient.create(CreativeTemplateServiceSettings.newBuilder().build());
    }

    public static final CreativeTemplateServiceClient create(CreativeTemplateServiceSettings settings) throws IOException {
        return new CreativeTemplateServiceClient(settings);
    }

    public static final CreativeTemplateServiceClient create(CreativeTemplateServiceStub stub) {
        return new CreativeTemplateServiceClient(stub);
    }

    protected CreativeTemplateServiceClient(CreativeTemplateServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CreativeTemplateServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CreativeTemplateServiceClient(CreativeTemplateServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CreativeTemplateServiceSettings getSettings() {
        return this.settings;
    }

    public CreativeTemplateServiceStub getStub() {
        return this.stub;
    }

    public final CreativeTemplate getCreativeTemplate(CreativeTemplateName name) {
        GetCreativeTemplateRequest request = GetCreativeTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCreativeTemplate(request);
    }

    public final CreativeTemplate getCreativeTemplate(String name) {
        GetCreativeTemplateRequest request = GetCreativeTemplateRequest.newBuilder().setName(name).build();
        return this.getCreativeTemplate(request);
    }

    public final CreativeTemplate getCreativeTemplate(GetCreativeTemplateRequest request) {
        return (CreativeTemplate)this.getCreativeTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetCreativeTemplateRequest, CreativeTemplate> getCreativeTemplateCallable() {
        return this.stub.getCreativeTemplateCallable();
    }

    public final ListCreativeTemplatesPagedResponse listCreativeTemplates(NetworkName parent) {
        ListCreativeTemplatesRequest request = ListCreativeTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCreativeTemplates(request);
    }

    public final ListCreativeTemplatesPagedResponse listCreativeTemplates(String parent) {
        ListCreativeTemplatesRequest request = ListCreativeTemplatesRequest.newBuilder().setParent(parent).build();
        return this.listCreativeTemplates(request);
    }

    public final ListCreativeTemplatesPagedResponse listCreativeTemplates(ListCreativeTemplatesRequest request) {
        return (ListCreativeTemplatesPagedResponse)((Object)this.listCreativeTemplatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCreativeTemplatesRequest, ListCreativeTemplatesPagedResponse> listCreativeTemplatesPagedCallable() {
        return this.stub.listCreativeTemplatesPagedCallable();
    }

    public final UnaryCallable<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse> listCreativeTemplatesCallable() {
        return this.stub.listCreativeTemplatesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCreativeTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplate, ListCreativeTemplatesPage, ListCreativeTemplatesFixedSizeCollection> {
        private ListCreativeTemplatesFixedSizeCollection(List<ListCreativeTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCreativeTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListCreativeTemplatesFixedSizeCollection(null, 0);
        }

        protected ListCreativeTemplatesFixedSizeCollection createCollection(List<ListCreativeTemplatesPage> pages, int collectionSize) {
            return new ListCreativeTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCreativeTemplatesPage
    extends AbstractPage<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplate, ListCreativeTemplatesPage> {
        private ListCreativeTemplatesPage(PageContext<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplate> context, ListCreativeTemplatesResponse response) {
            super(context, (Object)response);
        }

        private static ListCreativeTemplatesPage createEmptyPage() {
            return new ListCreativeTemplatesPage(null, null);
        }

        protected ListCreativeTemplatesPage createPage(PageContext<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplate> context, ListCreativeTemplatesResponse response) {
            return new ListCreativeTemplatesPage(context, response);
        }

        public ApiFuture<ListCreativeTemplatesPage> createPageAsync(PageContext<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplate> context, ApiFuture<ListCreativeTemplatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCreativeTemplatesPagedResponse
    extends AbstractPagedListResponse<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplate, ListCreativeTemplatesPage, ListCreativeTemplatesFixedSizeCollection> {
        public static ApiFuture<ListCreativeTemplatesPagedResponse> createAsync(PageContext<ListCreativeTemplatesRequest, ListCreativeTemplatesResponse, CreativeTemplate> context, ApiFuture<ListCreativeTemplatesResponse> futureResponse) {
            ApiFuture<ListCreativeTemplatesPage> futurePage = ListCreativeTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCreativeTemplatesPagedResponse((ListCreativeTemplatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCreativeTemplatesPagedResponse(ListCreativeTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCreativeTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

