/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.CmsMetadataValue;
import com.google.ads.admanager.v1.CmsMetadataValueName;
import com.google.ads.admanager.v1.CmsMetadataValueServiceSettings;
import com.google.ads.admanager.v1.GetCmsMetadataValueRequest;
import com.google.ads.admanager.v1.ListCmsMetadataValuesRequest;
import com.google.ads.admanager.v1.ListCmsMetadataValuesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.CmsMetadataValueServiceStub;
import com.google.ads.admanager.v1.stub.CmsMetadataValueServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CmsMetadataValueServiceClient
implements BackgroundResource {
    private final CmsMetadataValueServiceSettings settings;
    private final CmsMetadataValueServiceStub stub;

    public static final CmsMetadataValueServiceClient create() throws IOException {
        return CmsMetadataValueServiceClient.create(CmsMetadataValueServiceSettings.newBuilder().build());
    }

    public static final CmsMetadataValueServiceClient create(CmsMetadataValueServiceSettings settings) throws IOException {
        return new CmsMetadataValueServiceClient(settings);
    }

    public static final CmsMetadataValueServiceClient create(CmsMetadataValueServiceStub stub) {
        return new CmsMetadataValueServiceClient(stub);
    }

    protected CmsMetadataValueServiceClient(CmsMetadataValueServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CmsMetadataValueServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CmsMetadataValueServiceClient(CmsMetadataValueServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CmsMetadataValueServiceSettings getSettings() {
        return this.settings;
    }

    public CmsMetadataValueServiceStub getStub() {
        return this.stub;
    }

    public final CmsMetadataValue getCmsMetadataValue(CmsMetadataValueName name) {
        GetCmsMetadataValueRequest request = GetCmsMetadataValueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCmsMetadataValue(request);
    }

    public final CmsMetadataValue getCmsMetadataValue(String name) {
        GetCmsMetadataValueRequest request = GetCmsMetadataValueRequest.newBuilder().setName(name).build();
        return this.getCmsMetadataValue(request);
    }

    public final CmsMetadataValue getCmsMetadataValue(GetCmsMetadataValueRequest request) {
        return (CmsMetadataValue)this.getCmsMetadataValueCallable().call((Object)request);
    }

    public final UnaryCallable<GetCmsMetadataValueRequest, CmsMetadataValue> getCmsMetadataValueCallable() {
        return this.stub.getCmsMetadataValueCallable();
    }

    public final ListCmsMetadataValuesPagedResponse listCmsMetadataValues(NetworkName parent) {
        ListCmsMetadataValuesRequest request = ListCmsMetadataValuesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCmsMetadataValues(request);
    }

    public final ListCmsMetadataValuesPagedResponse listCmsMetadataValues(String parent) {
        ListCmsMetadataValuesRequest request = ListCmsMetadataValuesRequest.newBuilder().setParent(parent).build();
        return this.listCmsMetadataValues(request);
    }

    public final ListCmsMetadataValuesPagedResponse listCmsMetadataValues(ListCmsMetadataValuesRequest request) {
        return (ListCmsMetadataValuesPagedResponse)((Object)this.listCmsMetadataValuesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCmsMetadataValuesRequest, ListCmsMetadataValuesPagedResponse> listCmsMetadataValuesPagedCallable() {
        return this.stub.listCmsMetadataValuesPagedCallable();
    }

    public final UnaryCallable<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse> listCmsMetadataValuesCallable() {
        return this.stub.listCmsMetadataValuesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCmsMetadataValuesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValue, ListCmsMetadataValuesPage, ListCmsMetadataValuesFixedSizeCollection> {
        private ListCmsMetadataValuesFixedSizeCollection(List<ListCmsMetadataValuesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCmsMetadataValuesFixedSizeCollection createEmptyCollection() {
            return new ListCmsMetadataValuesFixedSizeCollection(null, 0);
        }

        protected ListCmsMetadataValuesFixedSizeCollection createCollection(List<ListCmsMetadataValuesPage> pages, int collectionSize) {
            return new ListCmsMetadataValuesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCmsMetadataValuesPage
    extends AbstractPage<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValue, ListCmsMetadataValuesPage> {
        private ListCmsMetadataValuesPage(PageContext<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValue> context, ListCmsMetadataValuesResponse response) {
            super(context, (Object)response);
        }

        private static ListCmsMetadataValuesPage createEmptyPage() {
            return new ListCmsMetadataValuesPage(null, null);
        }

        protected ListCmsMetadataValuesPage createPage(PageContext<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValue> context, ListCmsMetadataValuesResponse response) {
            return new ListCmsMetadataValuesPage(context, response);
        }

        public ApiFuture<ListCmsMetadataValuesPage> createPageAsync(PageContext<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValue> context, ApiFuture<ListCmsMetadataValuesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCmsMetadataValuesPagedResponse
    extends AbstractPagedListResponse<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValue, ListCmsMetadataValuesPage, ListCmsMetadataValuesFixedSizeCollection> {
        public static ApiFuture<ListCmsMetadataValuesPagedResponse> createAsync(PageContext<ListCmsMetadataValuesRequest, ListCmsMetadataValuesResponse, CmsMetadataValue> context, ApiFuture<ListCmsMetadataValuesResponse> futureResponse) {
            ApiFuture<ListCmsMetadataValuesPage> futurePage = ListCmsMetadataValuesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCmsMetadataValuesPagedResponse((ListCmsMetadataValuesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCmsMetadataValuesPagedResponse(ListCmsMetadataValuesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCmsMetadataValuesFixedSizeCollection.createEmptyCollection());
        }
    }
}

