/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.CmsMetadataKey;
import com.google.ads.admanager.v1.CmsMetadataKeyName;
import com.google.ads.admanager.v1.CmsMetadataKeyServiceSettings;
import com.google.ads.admanager.v1.GetCmsMetadataKeyRequest;
import com.google.ads.admanager.v1.ListCmsMetadataKeysRequest;
import com.google.ads.admanager.v1.ListCmsMetadataKeysResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.CmsMetadataKeyServiceStub;
import com.google.ads.admanager.v1.stub.CmsMetadataKeyServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CmsMetadataKeyServiceClient
implements BackgroundResource {
    private final CmsMetadataKeyServiceSettings settings;
    private final CmsMetadataKeyServiceStub stub;

    public static final CmsMetadataKeyServiceClient create() throws IOException {
        return CmsMetadataKeyServiceClient.create(CmsMetadataKeyServiceSettings.newBuilder().build());
    }

    public static final CmsMetadataKeyServiceClient create(CmsMetadataKeyServiceSettings settings) throws IOException {
        return new CmsMetadataKeyServiceClient(settings);
    }

    public static final CmsMetadataKeyServiceClient create(CmsMetadataKeyServiceStub stub) {
        return new CmsMetadataKeyServiceClient(stub);
    }

    protected CmsMetadataKeyServiceClient(CmsMetadataKeyServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CmsMetadataKeyServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CmsMetadataKeyServiceClient(CmsMetadataKeyServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CmsMetadataKeyServiceSettings getSettings() {
        return this.settings;
    }

    public CmsMetadataKeyServiceStub getStub() {
        return this.stub;
    }

    public final CmsMetadataKey getCmsMetadataKey(CmsMetadataKeyName name) {
        GetCmsMetadataKeyRequest request = GetCmsMetadataKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCmsMetadataKey(request);
    }

    public final CmsMetadataKey getCmsMetadataKey(String name) {
        GetCmsMetadataKeyRequest request = GetCmsMetadataKeyRequest.newBuilder().setName(name).build();
        return this.getCmsMetadataKey(request);
    }

    public final CmsMetadataKey getCmsMetadataKey(GetCmsMetadataKeyRequest request) {
        return (CmsMetadataKey)this.getCmsMetadataKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetCmsMetadataKeyRequest, CmsMetadataKey> getCmsMetadataKeyCallable() {
        return this.stub.getCmsMetadataKeyCallable();
    }

    public final ListCmsMetadataKeysPagedResponse listCmsMetadataKeys(NetworkName parent) {
        ListCmsMetadataKeysRequest request = ListCmsMetadataKeysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCmsMetadataKeys(request);
    }

    public final ListCmsMetadataKeysPagedResponse listCmsMetadataKeys(String parent) {
        ListCmsMetadataKeysRequest request = ListCmsMetadataKeysRequest.newBuilder().setParent(parent).build();
        return this.listCmsMetadataKeys(request);
    }

    public final ListCmsMetadataKeysPagedResponse listCmsMetadataKeys(ListCmsMetadataKeysRequest request) {
        return (ListCmsMetadataKeysPagedResponse)((Object)this.listCmsMetadataKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCmsMetadataKeysRequest, ListCmsMetadataKeysPagedResponse> listCmsMetadataKeysPagedCallable() {
        return this.stub.listCmsMetadataKeysPagedCallable();
    }

    public final UnaryCallable<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse> listCmsMetadataKeysCallable() {
        return this.stub.listCmsMetadataKeysCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCmsMetadataKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKey, ListCmsMetadataKeysPage, ListCmsMetadataKeysFixedSizeCollection> {
        private ListCmsMetadataKeysFixedSizeCollection(List<ListCmsMetadataKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCmsMetadataKeysFixedSizeCollection createEmptyCollection() {
            return new ListCmsMetadataKeysFixedSizeCollection(null, 0);
        }

        protected ListCmsMetadataKeysFixedSizeCollection createCollection(List<ListCmsMetadataKeysPage> pages, int collectionSize) {
            return new ListCmsMetadataKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCmsMetadataKeysPage
    extends AbstractPage<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKey, ListCmsMetadataKeysPage> {
        private ListCmsMetadataKeysPage(PageContext<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKey> context, ListCmsMetadataKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListCmsMetadataKeysPage createEmptyPage() {
            return new ListCmsMetadataKeysPage(null, null);
        }

        protected ListCmsMetadataKeysPage createPage(PageContext<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKey> context, ListCmsMetadataKeysResponse response) {
            return new ListCmsMetadataKeysPage(context, response);
        }

        public ApiFuture<ListCmsMetadataKeysPage> createPageAsync(PageContext<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKey> context, ApiFuture<ListCmsMetadataKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCmsMetadataKeysPagedResponse
    extends AbstractPagedListResponse<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKey, ListCmsMetadataKeysPage, ListCmsMetadataKeysFixedSizeCollection> {
        public static ApiFuture<ListCmsMetadataKeysPagedResponse> createAsync(PageContext<ListCmsMetadataKeysRequest, ListCmsMetadataKeysResponse, CmsMetadataKey> context, ApiFuture<ListCmsMetadataKeysResponse> futureResponse) {
            ApiFuture<ListCmsMetadataKeysPage> futurePage = ListCmsMetadataKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCmsMetadataKeysPagedResponse((ListCmsMetadataKeysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCmsMetadataKeysPagedResponse(ListCmsMetadataKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCmsMetadataKeysFixedSizeCollection.createEmptyCollection());
        }
    }
}

