/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.Browser;
import com.google.ads.admanager.v1.BrowserName;
import com.google.ads.admanager.v1.BrowserServiceSettings;
import com.google.ads.admanager.v1.GetBrowserRequest;
import com.google.ads.admanager.v1.ListBrowsersRequest;
import com.google.ads.admanager.v1.ListBrowsersResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.BrowserServiceStub;
import com.google.ads.admanager.v1.stub.BrowserServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BrowserServiceClient
implements BackgroundResource {
    private final BrowserServiceSettings settings;
    private final BrowserServiceStub stub;

    public static final BrowserServiceClient create() throws IOException {
        return BrowserServiceClient.create(BrowserServiceSettings.newBuilder().build());
    }

    public static final BrowserServiceClient create(BrowserServiceSettings settings) throws IOException {
        return new BrowserServiceClient(settings);
    }

    public static final BrowserServiceClient create(BrowserServiceStub stub) {
        return new BrowserServiceClient(stub);
    }

    protected BrowserServiceClient(BrowserServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BrowserServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected BrowserServiceClient(BrowserServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BrowserServiceSettings getSettings() {
        return this.settings;
    }

    public BrowserServiceStub getStub() {
        return this.stub;
    }

    public final Browser getBrowser(BrowserName name) {
        GetBrowserRequest request = GetBrowserRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBrowser(request);
    }

    public final Browser getBrowser(String name) {
        GetBrowserRequest request = GetBrowserRequest.newBuilder().setName(name).build();
        return this.getBrowser(request);
    }

    public final Browser getBrowser(GetBrowserRequest request) {
        return (Browser)this.getBrowserCallable().call((Object)request);
    }

    public final UnaryCallable<GetBrowserRequest, Browser> getBrowserCallable() {
        return this.stub.getBrowserCallable();
    }

    public final ListBrowsersPagedResponse listBrowsers(NetworkName parent) {
        ListBrowsersRequest request = ListBrowsersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBrowsers(request);
    }

    public final ListBrowsersPagedResponse listBrowsers(String parent) {
        ListBrowsersRequest request = ListBrowsersRequest.newBuilder().setParent(parent).build();
        return this.listBrowsers(request);
    }

    public final ListBrowsersPagedResponse listBrowsers(ListBrowsersRequest request) {
        return (ListBrowsersPagedResponse)((Object)this.listBrowsersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBrowsersRequest, ListBrowsersPagedResponse> listBrowsersPagedCallable() {
        return this.stub.listBrowsersPagedCallable();
    }

    public final UnaryCallable<ListBrowsersRequest, ListBrowsersResponse> listBrowsersCallable() {
        return this.stub.listBrowsersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBrowsersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBrowsersRequest, ListBrowsersResponse, Browser, ListBrowsersPage, ListBrowsersFixedSizeCollection> {
        private ListBrowsersFixedSizeCollection(List<ListBrowsersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBrowsersFixedSizeCollection createEmptyCollection() {
            return new ListBrowsersFixedSizeCollection(null, 0);
        }

        protected ListBrowsersFixedSizeCollection createCollection(List<ListBrowsersPage> pages, int collectionSize) {
            return new ListBrowsersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBrowsersPage
    extends AbstractPage<ListBrowsersRequest, ListBrowsersResponse, Browser, ListBrowsersPage> {
        private ListBrowsersPage(PageContext<ListBrowsersRequest, ListBrowsersResponse, Browser> context, ListBrowsersResponse response) {
            super(context, (Object)response);
        }

        private static ListBrowsersPage createEmptyPage() {
            return new ListBrowsersPage(null, null);
        }

        protected ListBrowsersPage createPage(PageContext<ListBrowsersRequest, ListBrowsersResponse, Browser> context, ListBrowsersResponse response) {
            return new ListBrowsersPage(context, response);
        }

        public ApiFuture<ListBrowsersPage> createPageAsync(PageContext<ListBrowsersRequest, ListBrowsersResponse, Browser> context, ApiFuture<ListBrowsersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBrowsersPagedResponse
    extends AbstractPagedListResponse<ListBrowsersRequest, ListBrowsersResponse, Browser, ListBrowsersPage, ListBrowsersFixedSizeCollection> {
        public static ApiFuture<ListBrowsersPagedResponse> createAsync(PageContext<ListBrowsersRequest, ListBrowsersResponse, Browser> context, ApiFuture<ListBrowsersResponse> futureResponse) {
            ApiFuture<ListBrowsersPage> futurePage = ListBrowsersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBrowsersPagedResponse((ListBrowsersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBrowsersPagedResponse(ListBrowsersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBrowsersFixedSizeCollection.createEmptyCollection());
        }
    }
}

