/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.CustomTargetingValue;
import com.google.ads.admanager.v1.CustomTargetingValueName;
import com.google.ads.admanager.v1.CustomTargetingValueServiceSettings;
import com.google.ads.admanager.v1.GetCustomTargetingValueRequest;
import com.google.ads.admanager.v1.ListCustomTargetingValuesRequest;
import com.google.ads.admanager.v1.ListCustomTargetingValuesResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.CustomTargetingValueServiceStub;
import com.google.ads.admanager.v1.stub.CustomTargetingValueServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CustomTargetingValueServiceClient
implements BackgroundResource {
    private final CustomTargetingValueServiceSettings settings;
    private final CustomTargetingValueServiceStub stub;

    public static final CustomTargetingValueServiceClient create() throws IOException {
        return CustomTargetingValueServiceClient.create(CustomTargetingValueServiceSettings.newBuilder().build());
    }

    public static final CustomTargetingValueServiceClient create(CustomTargetingValueServiceSettings settings) throws IOException {
        return new CustomTargetingValueServiceClient(settings);
    }

    public static final CustomTargetingValueServiceClient create(CustomTargetingValueServiceStub stub) {
        return new CustomTargetingValueServiceClient(stub);
    }

    protected CustomTargetingValueServiceClient(CustomTargetingValueServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomTargetingValueServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomTargetingValueServiceClient(CustomTargetingValueServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomTargetingValueServiceSettings getSettings() {
        return this.settings;
    }

    public CustomTargetingValueServiceStub getStub() {
        return this.stub;
    }

    public final CustomTargetingValue getCustomTargetingValue(CustomTargetingValueName name) {
        GetCustomTargetingValueRequest request = GetCustomTargetingValueRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomTargetingValue(request);
    }

    public final CustomTargetingValue getCustomTargetingValue(String name) {
        GetCustomTargetingValueRequest request = GetCustomTargetingValueRequest.newBuilder().setName(name).build();
        return this.getCustomTargetingValue(request);
    }

    public final CustomTargetingValue getCustomTargetingValue(GetCustomTargetingValueRequest request) {
        return (CustomTargetingValue)this.getCustomTargetingValueCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomTargetingValueRequest, CustomTargetingValue> getCustomTargetingValueCallable() {
        return this.stub.getCustomTargetingValueCallable();
    }

    public final ListCustomTargetingValuesPagedResponse listCustomTargetingValues(NetworkName parent) {
        ListCustomTargetingValuesRequest request = ListCustomTargetingValuesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCustomTargetingValues(request);
    }

    public final ListCustomTargetingValuesPagedResponse listCustomTargetingValues(String parent) {
        ListCustomTargetingValuesRequest request = ListCustomTargetingValuesRequest.newBuilder().setParent(parent).build();
        return this.listCustomTargetingValues(request);
    }

    public final ListCustomTargetingValuesPagedResponse listCustomTargetingValues(ListCustomTargetingValuesRequest request) {
        return (ListCustomTargetingValuesPagedResponse)((Object)this.listCustomTargetingValuesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomTargetingValuesRequest, ListCustomTargetingValuesPagedResponse> listCustomTargetingValuesPagedCallable() {
        return this.stub.listCustomTargetingValuesPagedCallable();
    }

    public final UnaryCallable<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse> listCustomTargetingValuesCallable() {
        return this.stub.listCustomTargetingValuesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCustomTargetingValuesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValue, ListCustomTargetingValuesPage, ListCustomTargetingValuesFixedSizeCollection> {
        private ListCustomTargetingValuesFixedSizeCollection(List<ListCustomTargetingValuesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomTargetingValuesFixedSizeCollection createEmptyCollection() {
            return new ListCustomTargetingValuesFixedSizeCollection(null, 0);
        }

        protected ListCustomTargetingValuesFixedSizeCollection createCollection(List<ListCustomTargetingValuesPage> pages, int collectionSize) {
            return new ListCustomTargetingValuesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomTargetingValuesPage
    extends AbstractPage<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValue, ListCustomTargetingValuesPage> {
        private ListCustomTargetingValuesPage(PageContext<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValue> context, ListCustomTargetingValuesResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomTargetingValuesPage createEmptyPage() {
            return new ListCustomTargetingValuesPage(null, null);
        }

        protected ListCustomTargetingValuesPage createPage(PageContext<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValue> context, ListCustomTargetingValuesResponse response) {
            return new ListCustomTargetingValuesPage(context, response);
        }

        public ApiFuture<ListCustomTargetingValuesPage> createPageAsync(PageContext<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValue> context, ApiFuture<ListCustomTargetingValuesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomTargetingValuesPagedResponse
    extends AbstractPagedListResponse<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValue, ListCustomTargetingValuesPage, ListCustomTargetingValuesFixedSizeCollection> {
        public static ApiFuture<ListCustomTargetingValuesPagedResponse> createAsync(PageContext<ListCustomTargetingValuesRequest, ListCustomTargetingValuesResponse, CustomTargetingValue> context, ApiFuture<ListCustomTargetingValuesResponse> futureResponse) {
            ApiFuture<ListCustomTargetingValuesPage> futurePage = ListCustomTargetingValuesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomTargetingValuesPagedResponse((ListCustomTargetingValuesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomTargetingValuesPagedResponse(ListCustomTargetingValuesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomTargetingValuesFixedSizeCollection.createEmptyCollection());
        }
    }
}

