/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.Company;
import com.google.ads.admanager.v1.CompanyServiceClient;
import com.google.ads.admanager.v1.GetCompanyRequest;
import com.google.ads.admanager.v1.ListCompaniesRequest;
import com.google.ads.admanager.v1.ListCompaniesResponse;
import com.google.ads.admanager.v1.stub.CompanyServiceStub;
import com.google.ads.admanager.v1.stub.CompanyServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonCompanyServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonCompanyServiceStub
extends CompanyServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetCompanyRequest, Company> getCompanyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.CompanyService/GetCompany").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/companies/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Company.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCompaniesRequest, ListCompaniesResponse> listCompaniesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.CompanyService/ListCompanies").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/companies", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCompaniesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetCompanyRequest, Company> getCompanyCallable;
    private final UnaryCallable<ListCompaniesRequest, ListCompaniesResponse> listCompaniesCallable;
    private final UnaryCallable<ListCompaniesRequest, CompanyServiceClient.ListCompaniesPagedResponse> listCompaniesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCompanyServiceStub create(CompanyServiceStubSettings settings) throws IOException {
        return new HttpJsonCompanyServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCompanyServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCompanyServiceStub(CompanyServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonCompanyServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCompanyServiceStub(CompanyServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCompanyServiceStub(CompanyServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCompanyServiceCallableFactory());
    }

    protected HttpJsonCompanyServiceStub(CompanyServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getCompanyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCompanyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listCompaniesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCompaniesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getCompanyCallable = callableFactory.createUnaryCallable(getCompanyTransportSettings, settings.getCompanySettings(), clientContext);
        this.listCompaniesCallable = callableFactory.createUnaryCallable(listCompaniesTransportSettings, settings.listCompaniesSettings(), clientContext);
        this.listCompaniesPagedCallable = callableFactory.createPagedCallable(listCompaniesTransportSettings, settings.listCompaniesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getCompanyMethodDescriptor);
        methodDescriptors.add(listCompaniesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetCompanyRequest, Company> getCompanyCallable() {
        return this.getCompanyCallable;
    }

    @Override
    public UnaryCallable<ListCompaniesRequest, ListCompaniesResponse> listCompaniesCallable() {
        return this.listCompaniesCallable;
    }

    @Override
    public UnaryCallable<ListCompaniesRequest, CompanyServiceClient.ListCompaniesPagedResponse> listCompaniesPagedCallable() {
        return this.listCompaniesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

