/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.AdBreak;
import com.google.ads.admanager.v1.AdBreakServiceClient;
import com.google.ads.admanager.v1.CreateAdBreakRequest;
import com.google.ads.admanager.v1.DeleteAdBreakRequest;
import com.google.ads.admanager.v1.GetAdBreakRequest;
import com.google.ads.admanager.v1.ListAdBreaksRequest;
import com.google.ads.admanager.v1.ListAdBreaksResponse;
import com.google.ads.admanager.v1.UpdateAdBreakRequest;
import com.google.ads.admanager.v1.stub.AdBreakServiceStub;
import com.google.ads.admanager.v1.stub.AdBreakServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonAdBreakServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonAdBreakServiceStub
extends AdBreakServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetAdBreakRequest, AdBreak> getAdBreakMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.AdBreakService/GetAdBreak").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/liveStreamEventsByAssetKey/*/adBreaks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=networks/*/liveStreamEventsByCustomAssetKey/*/adBreaks/*}", "/v1/{name=networks/*/liveStreamEvents/*/adBreaks/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AdBreak.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListAdBreaksRequest, ListAdBreaksResponse> listAdBreaksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.AdBreakService/ListAdBreaks").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*/liveStreamEventsByAssetKey/*}/adBreaks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=networks/*/liveStreamEventsByCustomAssetKey/*}/adBreaks", "/v1/{parent=networks/*/liveStreamEvents/*}/adBreaks"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListAdBreaksResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateAdBreakRequest, AdBreak> createAdBreakMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.AdBreakService/CreateAdBreak").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*/liveStreamEventsByAssetKey/*}/adBreaks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=networks/*/liveStreamEventsByCustomAssetKey/*}/adBreaks", "/v1/{parent=networks/*/liveStreamEvents/*}/adBreaks"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("adBreak", (Message)request.getAdBreak(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AdBreak.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateAdBreakRequest, AdBreak> updateAdBreakMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.AdBreakService/UpdateAdBreak").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{adBreak.name=networks/*/liveStreamEventsByAssetKey/*/adBreaks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "adBreak.name", (Object)request.getAdBreak().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("adBreak", (Message)request.getAdBreak(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AdBreak.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteAdBreakRequest, Empty> deleteAdBreakMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.AdBreakService/DeleteAdBreak").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/liveStreamEventsByAssetKey/*/adBreaks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetAdBreakRequest, AdBreak> getAdBreakCallable;
    private final UnaryCallable<ListAdBreaksRequest, ListAdBreaksResponse> listAdBreaksCallable;
    private final UnaryCallable<ListAdBreaksRequest, AdBreakServiceClient.ListAdBreaksPagedResponse> listAdBreaksPagedCallable;
    private final UnaryCallable<CreateAdBreakRequest, AdBreak> createAdBreakCallable;
    private final UnaryCallable<UpdateAdBreakRequest, AdBreak> updateAdBreakCallable;
    private final UnaryCallable<DeleteAdBreakRequest, Empty> deleteAdBreakCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAdBreakServiceStub create(AdBreakServiceStubSettings settings) throws IOException {
        return new HttpJsonAdBreakServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAdBreakServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAdBreakServiceStub(AdBreakServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonAdBreakServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAdBreakServiceStub(AdBreakServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAdBreakServiceStub(AdBreakServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAdBreakServiceCallableFactory());
    }

    protected HttpJsonAdBreakServiceStub(AdBreakServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getAdBreakTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAdBreakMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listAdBreaksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listAdBreaksMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createAdBreakTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createAdBreakMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateAdBreakTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateAdBreakMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("ad_break.name", String.valueOf(request.getAdBreak().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteAdBreakTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteAdBreakMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getAdBreakCallable = callableFactory.createUnaryCallable(getAdBreakTransportSettings, settings.getAdBreakSettings(), clientContext);
        this.listAdBreaksCallable = callableFactory.createUnaryCallable(listAdBreaksTransportSettings, settings.listAdBreaksSettings(), clientContext);
        this.listAdBreaksPagedCallable = callableFactory.createPagedCallable(listAdBreaksTransportSettings, settings.listAdBreaksSettings(), clientContext);
        this.createAdBreakCallable = callableFactory.createUnaryCallable(createAdBreakTransportSettings, settings.createAdBreakSettings(), clientContext);
        this.updateAdBreakCallable = callableFactory.createUnaryCallable(updateAdBreakTransportSettings, settings.updateAdBreakSettings(), clientContext);
        this.deleteAdBreakCallable = callableFactory.createUnaryCallable(deleteAdBreakTransportSettings, settings.deleteAdBreakSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getAdBreakMethodDescriptor);
        methodDescriptors.add(listAdBreaksMethodDescriptor);
        methodDescriptors.add(createAdBreakMethodDescriptor);
        methodDescriptors.add(updateAdBreakMethodDescriptor);
        methodDescriptors.add(deleteAdBreakMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetAdBreakRequest, AdBreak> getAdBreakCallable() {
        return this.getAdBreakCallable;
    }

    @Override
    public UnaryCallable<ListAdBreaksRequest, ListAdBreaksResponse> listAdBreaksCallable() {
        return this.listAdBreaksCallable;
    }

    @Override
    public UnaryCallable<ListAdBreaksRequest, AdBreakServiceClient.ListAdBreaksPagedResponse> listAdBreaksPagedCallable() {
        return this.listAdBreaksPagedCallable;
    }

    @Override
    public UnaryCallable<CreateAdBreakRequest, AdBreak> createAdBreakCallable() {
        return this.createAdBreakCallable;
    }

    @Override
    public UnaryCallable<UpdateAdBreakRequest, AdBreak> updateAdBreakCallable() {
        return this.updateAdBreakCallable;
    }

    @Override
    public UnaryCallable<DeleteAdBreakRequest, Empty> deleteAdBreakCallable() {
        return this.deleteAdBreakCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

