/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetOperatingSystemVersionRequest;
import com.google.ads.admanager.v1.ListOperatingSystemVersionsRequest;
import com.google.ads.admanager.v1.ListOperatingSystemVersionsResponse;
import com.google.ads.admanager.v1.OperatingSystemVersion;
import com.google.ads.admanager.v1.OperatingSystemVersionServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonOperatingSystemVersionServiceStub;
import com.google.ads.admanager.v1.stub.OperatingSystemVersionServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class OperatingSystemVersionServiceStubSettings
extends StubSettings<OperatingSystemVersionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetOperatingSystemVersionRequest, OperatingSystemVersion> getOperatingSystemVersionSettings;
    private final PagedCallSettings<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersionServiceClient.ListOperatingSystemVersionsPagedResponse> listOperatingSystemVersionsSettings;
    private static final PagedListDescriptor<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersion> LIST_OPERATING_SYSTEM_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListOperatingSystemVersionsRequest injectToken(ListOperatingSystemVersionsRequest payload, String token) {
            return ListOperatingSystemVersionsRequest.newBuilder((ListOperatingSystemVersionsRequest)payload).setPageToken(token).build();
        }

        public ListOperatingSystemVersionsRequest injectPageSize(ListOperatingSystemVersionsRequest payload, int pageSize) {
            return ListOperatingSystemVersionsRequest.newBuilder((ListOperatingSystemVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOperatingSystemVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOperatingSystemVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<OperatingSystemVersion> extractResources(ListOperatingSystemVersionsResponse payload) {
            return payload.getOperatingSystemVersionsList();
        }
    };
    private static final PagedListResponseFactory<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersionServiceClient.ListOperatingSystemVersionsPagedResponse> LIST_OPERATING_SYSTEM_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersionServiceClient.ListOperatingSystemVersionsPagedResponse>(){

        public ApiFuture<OperatingSystemVersionServiceClient.ListOperatingSystemVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse> callable, ListOperatingSystemVersionsRequest request, ApiCallContext context, ApiFuture<ListOperatingSystemVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_OPERATING_SYSTEM_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OperatingSystemVersionServiceClient.ListOperatingSystemVersionsPagedResponse.createAsync((PageContext<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersion>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetOperatingSystemVersionRequest, OperatingSystemVersion> getOperatingSystemVersionSettings() {
        return this.getOperatingSystemVersionSettings;
    }

    public PagedCallSettings<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersionServiceClient.ListOperatingSystemVersionsPagedResponse> listOperatingSystemVersionsSettings() {
        return this.listOperatingSystemVersionsSettings;
    }

    public OperatingSystemVersionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonOperatingSystemVersionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OperatingSystemVersionServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OperatingSystemVersionServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OperatingSystemVersionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getOperatingSystemVersionSettings = settingsBuilder.getOperatingSystemVersionSettings().build();
        this.listOperatingSystemVersionsSettings = settingsBuilder.listOperatingSystemVersionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OperatingSystemVersionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetOperatingSystemVersionRequest, OperatingSystemVersion> getOperatingSystemVersionSettings;
        private final PagedCallSettings.Builder<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersionServiceClient.ListOperatingSystemVersionsPagedResponse> listOperatingSystemVersionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getOperatingSystemVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOperatingSystemVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_OPERATING_SYSTEM_VERSIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOperatingSystemVersionSettings, this.listOperatingSystemVersionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(OperatingSystemVersionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getOperatingSystemVersionSettings = settings.getOperatingSystemVersionSettings.toBuilder();
            this.listOperatingSystemVersionsSettings = settings.listOperatingSystemVersionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOperatingSystemVersionSettings, this.listOperatingSystemVersionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OperatingSystemVersionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OperatingSystemVersionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OperatingSystemVersionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OperatingSystemVersionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getOperatingSystemVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listOperatingSystemVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetOperatingSystemVersionRequest, OperatingSystemVersion> getOperatingSystemVersionSettings() {
            return this.getOperatingSystemVersionSettings;
        }

        public PagedCallSettings.Builder<ListOperatingSystemVersionsRequest, ListOperatingSystemVersionsResponse, OperatingSystemVersionServiceClient.ListOperatingSystemVersionsPagedResponse> listOperatingSystemVersionsSettings() {
            return this.listOperatingSystemVersionsSettings;
        }

        public OperatingSystemVersionServiceStubSettings build() throws IOException {
            return new OperatingSystemVersionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

