/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.BandwidthGroup;
import com.google.ads.admanager.v1.BandwidthGroupServiceClient;
import com.google.ads.admanager.v1.GetBandwidthGroupRequest;
import com.google.ads.admanager.v1.ListBandwidthGroupsRequest;
import com.google.ads.admanager.v1.ListBandwidthGroupsResponse;
import com.google.ads.admanager.v1.stub.BandwidthGroupServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonBandwidthGroupServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class BandwidthGroupServiceStubSettings
extends StubSettings<BandwidthGroupServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetBandwidthGroupRequest, BandwidthGroup> getBandwidthGroupSettings;
    private final PagedCallSettings<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroupServiceClient.ListBandwidthGroupsPagedResponse> listBandwidthGroupsSettings;
    private static final PagedListDescriptor<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroup> LIST_BANDWIDTH_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListBandwidthGroupsRequest injectToken(ListBandwidthGroupsRequest payload, String token) {
            return ListBandwidthGroupsRequest.newBuilder((ListBandwidthGroupsRequest)payload).setPageToken(token).build();
        }

        public ListBandwidthGroupsRequest injectPageSize(ListBandwidthGroupsRequest payload, int pageSize) {
            return ListBandwidthGroupsRequest.newBuilder((ListBandwidthGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBandwidthGroupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBandwidthGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BandwidthGroup> extractResources(ListBandwidthGroupsResponse payload) {
            return payload.getBandwidthGroupsList();
        }
    };
    private static final PagedListResponseFactory<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroupServiceClient.ListBandwidthGroupsPagedResponse> LIST_BANDWIDTH_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroupServiceClient.ListBandwidthGroupsPagedResponse>(){

        public ApiFuture<BandwidthGroupServiceClient.ListBandwidthGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse> callable, ListBandwidthGroupsRequest request, ApiCallContext context, ApiFuture<ListBandwidthGroupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BANDWIDTH_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BandwidthGroupServiceClient.ListBandwidthGroupsPagedResponse.createAsync((PageContext<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroup>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetBandwidthGroupRequest, BandwidthGroup> getBandwidthGroupSettings() {
        return this.getBandwidthGroupSettings;
    }

    public PagedCallSettings<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroupServiceClient.ListBandwidthGroupsPagedResponse> listBandwidthGroupsSettings() {
        return this.listBandwidthGroupsSettings;
    }

    public BandwidthGroupServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBandwidthGroupServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BandwidthGroupServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BandwidthGroupServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BandwidthGroupServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getBandwidthGroupSettings = settingsBuilder.getBandwidthGroupSettings().build();
        this.listBandwidthGroupsSettings = settingsBuilder.listBandwidthGroupsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BandwidthGroupServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetBandwidthGroupRequest, BandwidthGroup> getBandwidthGroupSettings;
        private final PagedCallSettings.Builder<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroupServiceClient.ListBandwidthGroupsPagedResponse> listBandwidthGroupsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getBandwidthGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBandwidthGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BANDWIDTH_GROUPS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getBandwidthGroupSettings, this.listBandwidthGroupsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(BandwidthGroupServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getBandwidthGroupSettings = settings.getBandwidthGroupSettings.toBuilder();
            this.listBandwidthGroupsSettings = settings.listBandwidthGroupsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getBandwidthGroupSettings, this.listBandwidthGroupsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BandwidthGroupServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BandwidthGroupServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BandwidthGroupServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BandwidthGroupServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getBandwidthGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listBandwidthGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetBandwidthGroupRequest, BandwidthGroup> getBandwidthGroupSettings() {
            return this.getBandwidthGroupSettings;
        }

        public PagedCallSettings.Builder<ListBandwidthGroupsRequest, ListBandwidthGroupsResponse, BandwidthGroupServiceClient.ListBandwidthGroupsPagedResponse> listBandwidthGroupsSettings() {
            return this.listBandwidthGroupsSettings;
        }

        public BandwidthGroupServiceStubSettings build() throws IOException {
            return new BandwidthGroupServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

