/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetLabelRequest;
import com.google.ads.admanager.v1.Label;
import com.google.ads.admanager.v1.LabelName;
import com.google.ads.admanager.v1.LabelServiceSettings;
import com.google.ads.admanager.v1.ListLabelsRequest;
import com.google.ads.admanager.v1.ListLabelsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.LabelServiceStub;
import com.google.ads.admanager.v1.stub.LabelServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class LabelServiceClient
implements BackgroundResource {
    private final LabelServiceSettings settings;
    private final LabelServiceStub stub;

    public static final LabelServiceClient create() throws IOException {
        return LabelServiceClient.create(LabelServiceSettings.newBuilder().build());
    }

    public static final LabelServiceClient create(LabelServiceSettings settings) throws IOException {
        return new LabelServiceClient(settings);
    }

    public static final LabelServiceClient create(LabelServiceStub stub) {
        return new LabelServiceClient(stub);
    }

    protected LabelServiceClient(LabelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LabelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected LabelServiceClient(LabelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LabelServiceSettings getSettings() {
        return this.settings;
    }

    public LabelServiceStub getStub() {
        return this.stub;
    }

    public final Label getLabel(LabelName name) {
        GetLabelRequest request = GetLabelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLabel(request);
    }

    public final Label getLabel(String name) {
        GetLabelRequest request = GetLabelRequest.newBuilder().setName(name).build();
        return this.getLabel(request);
    }

    public final Label getLabel(GetLabelRequest request) {
        return (Label)this.getLabelCallable().call((Object)request);
    }

    public final UnaryCallable<GetLabelRequest, Label> getLabelCallable() {
        return this.stub.getLabelCallable();
    }

    public final ListLabelsPagedResponse listLabels(NetworkName parent) {
        ListLabelsRequest request = ListLabelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLabels(request);
    }

    public final ListLabelsPagedResponse listLabels(String parent) {
        ListLabelsRequest request = ListLabelsRequest.newBuilder().setParent(parent).build();
        return this.listLabels(request);
    }

    public final ListLabelsPagedResponse listLabels(ListLabelsRequest request) {
        return (ListLabelsPagedResponse)((Object)this.listLabelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLabelsRequest, ListLabelsPagedResponse> listLabelsPagedCallable() {
        return this.stub.listLabelsPagedCallable();
    }

    public final UnaryCallable<ListLabelsRequest, ListLabelsResponse> listLabelsCallable() {
        return this.stub.listLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLabelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLabelsRequest, ListLabelsResponse, Label, ListLabelsPage, ListLabelsFixedSizeCollection> {
        private ListLabelsFixedSizeCollection(List<ListLabelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLabelsFixedSizeCollection createEmptyCollection() {
            return new ListLabelsFixedSizeCollection(null, 0);
        }

        protected ListLabelsFixedSizeCollection createCollection(List<ListLabelsPage> pages, int collectionSize) {
            return new ListLabelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLabelsPage
    extends AbstractPage<ListLabelsRequest, ListLabelsResponse, Label, ListLabelsPage> {
        private ListLabelsPage(PageContext<ListLabelsRequest, ListLabelsResponse, Label> context, ListLabelsResponse response) {
            super(context, (Object)response);
        }

        private static ListLabelsPage createEmptyPage() {
            return new ListLabelsPage(null, null);
        }

        protected ListLabelsPage createPage(PageContext<ListLabelsRequest, ListLabelsResponse, Label> context, ListLabelsResponse response) {
            return new ListLabelsPage(context, response);
        }

        public ApiFuture<ListLabelsPage> createPageAsync(PageContext<ListLabelsRequest, ListLabelsResponse, Label> context, ApiFuture<ListLabelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLabelsPagedResponse
    extends AbstractPagedListResponse<ListLabelsRequest, ListLabelsResponse, Label, ListLabelsPage, ListLabelsFixedSizeCollection> {
        public static ApiFuture<ListLabelsPagedResponse> createAsync(PageContext<ListLabelsRequest, ListLabelsResponse, Label> context, ApiFuture<ListLabelsResponse> futureResponse) {
            ApiFuture<ListLabelsPage> futurePage = ListLabelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLabelsPagedResponse((ListLabelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLabelsPagedResponse(ListLabelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLabelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

