/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.DeviceCategory;
import com.google.ads.admanager.v1.DeviceCategoryServiceClient;
import com.google.ads.admanager.v1.GetDeviceCategoryRequest;
import com.google.ads.admanager.v1.ListDeviceCategoriesRequest;
import com.google.ads.admanager.v1.ListDeviceCategoriesResponse;
import com.google.ads.admanager.v1.stub.DeviceCategoryServiceStub;
import com.google.ads.admanager.v1.stub.HttpJsonDeviceCategoryServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DeviceCategoryServiceStubSettings
extends StubSettings<DeviceCategoryServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/admanager").build();
    private final UnaryCallSettings<GetDeviceCategoryRequest, DeviceCategory> getDeviceCategorySettings;
    private final PagedCallSettings<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategoryServiceClient.ListDeviceCategoriesPagedResponse> listDeviceCategoriesSettings;
    private static final PagedListDescriptor<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategory> LIST_DEVICE_CATEGORIES_PAGE_STR_DESC = new PagedListDescriptor<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategory>(){

        public String emptyToken() {
            return "";
        }

        public ListDeviceCategoriesRequest injectToken(ListDeviceCategoriesRequest payload, String token) {
            return ListDeviceCategoriesRequest.newBuilder((ListDeviceCategoriesRequest)payload).setPageToken(token).build();
        }

        public ListDeviceCategoriesRequest injectPageSize(ListDeviceCategoriesRequest payload, int pageSize) {
            return ListDeviceCategoriesRequest.newBuilder((ListDeviceCategoriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeviceCategoriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeviceCategoriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DeviceCategory> extractResources(ListDeviceCategoriesResponse payload) {
            return payload.getDeviceCategoriesList();
        }
    };
    private static final PagedListResponseFactory<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategoryServiceClient.ListDeviceCategoriesPagedResponse> LIST_DEVICE_CATEGORIES_PAGE_STR_FACT = new PagedListResponseFactory<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategoryServiceClient.ListDeviceCategoriesPagedResponse>(){

        public ApiFuture<DeviceCategoryServiceClient.ListDeviceCategoriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse> callable, ListDeviceCategoriesRequest request, ApiCallContext context, ApiFuture<ListDeviceCategoriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEVICE_CATEGORIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeviceCategoryServiceClient.ListDeviceCategoriesPagedResponse.createAsync((PageContext<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategory>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetDeviceCategoryRequest, DeviceCategory> getDeviceCategorySettings() {
        return this.getDeviceCategorySettings;
    }

    public PagedCallSettings<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategoryServiceClient.ListDeviceCategoriesPagedResponse> listDeviceCategoriesSettings() {
        return this.listDeviceCategoriesSettings;
    }

    public DeviceCategoryServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDeviceCategoryServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DeviceCategoryServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeviceCategoryServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DeviceCategoryServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getDeviceCategorySettings = settingsBuilder.getDeviceCategorySettings().build();
        this.listDeviceCategoriesSettings = settingsBuilder.listDeviceCategoriesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DeviceCategoryServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetDeviceCategoryRequest, DeviceCategory> getDeviceCategorySettings;
        private final PagedCallSettings.Builder<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategoryServiceClient.ListDeviceCategoriesPagedResponse> listDeviceCategoriesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getDeviceCategorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeviceCategoriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEVICE_CATEGORIES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDeviceCategorySettings, this.listDeviceCategoriesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DeviceCategoryServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getDeviceCategorySettings = settings.getDeviceCategorySettings.toBuilder();
            this.listDeviceCategoriesSettings = settings.listDeviceCategoriesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDeviceCategorySettings, this.listDeviceCategoriesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DeviceCategoryServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DeviceCategoryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeviceCategoryServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DeviceCategoryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getDeviceCategorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDeviceCategoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetDeviceCategoryRequest, DeviceCategory> getDeviceCategorySettings() {
            return this.getDeviceCategorySettings;
        }

        public PagedCallSettings.Builder<ListDeviceCategoriesRequest, ListDeviceCategoriesResponse, DeviceCategoryServiceClient.ListDeviceCategoriesPagedResponse> listDeviceCategoriesSettings() {
            return this.listDeviceCategoriesSettings;
        }

        public DeviceCategoryServiceStubSettings build() throws IOException {
            return new DeviceCategoryServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

