/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.CreatePrivateAuctionRequest;
import com.google.ads.admanager.v1.GetPrivateAuctionRequest;
import com.google.ads.admanager.v1.ListPrivateAuctionsRequest;
import com.google.ads.admanager.v1.ListPrivateAuctionsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.PrivateAuction;
import com.google.ads.admanager.v1.PrivateAuctionName;
import com.google.ads.admanager.v1.PrivateAuctionServiceSettings;
import com.google.ads.admanager.v1.UpdatePrivateAuctionRequest;
import com.google.ads.admanager.v1.stub.PrivateAuctionServiceStub;
import com.google.ads.admanager.v1.stub.PrivateAuctionServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class PrivateAuctionServiceClient
implements BackgroundResource {
    private final PrivateAuctionServiceSettings settings;
    private final PrivateAuctionServiceStub stub;

    public static final PrivateAuctionServiceClient create() throws IOException {
        return PrivateAuctionServiceClient.create(PrivateAuctionServiceSettings.newBuilder().build());
    }

    public static final PrivateAuctionServiceClient create(PrivateAuctionServiceSettings settings) throws IOException {
        return new PrivateAuctionServiceClient(settings);
    }

    public static final PrivateAuctionServiceClient create(PrivateAuctionServiceStub stub) {
        return new PrivateAuctionServiceClient(stub);
    }

    protected PrivateAuctionServiceClient(PrivateAuctionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PrivateAuctionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected PrivateAuctionServiceClient(PrivateAuctionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PrivateAuctionServiceSettings getSettings() {
        return this.settings;
    }

    public PrivateAuctionServiceStub getStub() {
        return this.stub;
    }

    public final PrivateAuction getPrivateAuction(PrivateAuctionName name) {
        GetPrivateAuctionRequest request = GetPrivateAuctionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPrivateAuction(request);
    }

    public final PrivateAuction getPrivateAuction(String name) {
        GetPrivateAuctionRequest request = GetPrivateAuctionRequest.newBuilder().setName(name).build();
        return this.getPrivateAuction(request);
    }

    public final PrivateAuction getPrivateAuction(GetPrivateAuctionRequest request) {
        return (PrivateAuction)this.getPrivateAuctionCallable().call((Object)request);
    }

    public final UnaryCallable<GetPrivateAuctionRequest, PrivateAuction> getPrivateAuctionCallable() {
        return this.stub.getPrivateAuctionCallable();
    }

    public final ListPrivateAuctionsPagedResponse listPrivateAuctions(NetworkName parent) {
        ListPrivateAuctionsRequest request = ListPrivateAuctionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrivateAuctions(request);
    }

    public final ListPrivateAuctionsPagedResponse listPrivateAuctions(String parent) {
        ListPrivateAuctionsRequest request = ListPrivateAuctionsRequest.newBuilder().setParent(parent).build();
        return this.listPrivateAuctions(request);
    }

    public final ListPrivateAuctionsPagedResponse listPrivateAuctions(ListPrivateAuctionsRequest request) {
        return (ListPrivateAuctionsPagedResponse)((Object)this.listPrivateAuctionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPrivateAuctionsRequest, ListPrivateAuctionsPagedResponse> listPrivateAuctionsPagedCallable() {
        return this.stub.listPrivateAuctionsPagedCallable();
    }

    public final UnaryCallable<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse> listPrivateAuctionsCallable() {
        return this.stub.listPrivateAuctionsCallable();
    }

    public final PrivateAuction createPrivateAuction(NetworkName parent, PrivateAuction privateAuction) {
        CreatePrivateAuctionRequest request = CreatePrivateAuctionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPrivateAuction(privateAuction).build();
        return this.createPrivateAuction(request);
    }

    public final PrivateAuction createPrivateAuction(String parent, PrivateAuction privateAuction) {
        CreatePrivateAuctionRequest request = CreatePrivateAuctionRequest.newBuilder().setParent(parent).setPrivateAuction(privateAuction).build();
        return this.createPrivateAuction(request);
    }

    public final PrivateAuction createPrivateAuction(CreatePrivateAuctionRequest request) {
        return (PrivateAuction)this.createPrivateAuctionCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePrivateAuctionRequest, PrivateAuction> createPrivateAuctionCallable() {
        return this.stub.createPrivateAuctionCallable();
    }

    public final PrivateAuction updatePrivateAuction(PrivateAuction privateAuction, FieldMask updateMask) {
        UpdatePrivateAuctionRequest request = UpdatePrivateAuctionRequest.newBuilder().setPrivateAuction(privateAuction).setUpdateMask(updateMask).build();
        return this.updatePrivateAuction(request);
    }

    public final PrivateAuction updatePrivateAuction(UpdatePrivateAuctionRequest request) {
        return (PrivateAuction)this.updatePrivateAuctionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePrivateAuctionRequest, PrivateAuction> updatePrivateAuctionCallable() {
        return this.stub.updatePrivateAuctionCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPrivateAuctionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuction, ListPrivateAuctionsPage, ListPrivateAuctionsFixedSizeCollection> {
        private ListPrivateAuctionsFixedSizeCollection(List<ListPrivateAuctionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPrivateAuctionsFixedSizeCollection createEmptyCollection() {
            return new ListPrivateAuctionsFixedSizeCollection(null, 0);
        }

        protected ListPrivateAuctionsFixedSizeCollection createCollection(List<ListPrivateAuctionsPage> pages, int collectionSize) {
            return new ListPrivateAuctionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPrivateAuctionsPage
    extends AbstractPage<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuction, ListPrivateAuctionsPage> {
        private ListPrivateAuctionsPage(PageContext<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuction> context, ListPrivateAuctionsResponse response) {
            super(context, (Object)response);
        }

        private static ListPrivateAuctionsPage createEmptyPage() {
            return new ListPrivateAuctionsPage(null, null);
        }

        protected ListPrivateAuctionsPage createPage(PageContext<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuction> context, ListPrivateAuctionsResponse response) {
            return new ListPrivateAuctionsPage(context, response);
        }

        public ApiFuture<ListPrivateAuctionsPage> createPageAsync(PageContext<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuction> context, ApiFuture<ListPrivateAuctionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPrivateAuctionsPagedResponse
    extends AbstractPagedListResponse<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuction, ListPrivateAuctionsPage, ListPrivateAuctionsFixedSizeCollection> {
        public static ApiFuture<ListPrivateAuctionsPagedResponse> createAsync(PageContext<ListPrivateAuctionsRequest, ListPrivateAuctionsResponse, PrivateAuction> context, ApiFuture<ListPrivateAuctionsResponse> futureResponse) {
            ApiFuture<ListPrivateAuctionsPage> futurePage = ListPrivateAuctionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPrivateAuctionsPagedResponse((ListPrivateAuctionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPrivateAuctionsPagedResponse(ListPrivateAuctionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPrivateAuctionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

