/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.BatchCreateEntitySignalsMappingsRequest;
import com.google.ads.admanager.v1.BatchCreateEntitySignalsMappingsResponse;
import com.google.ads.admanager.v1.BatchUpdateEntitySignalsMappingsRequest;
import com.google.ads.admanager.v1.BatchUpdateEntitySignalsMappingsResponse;
import com.google.ads.admanager.v1.CreateEntitySignalsMappingRequest;
import com.google.ads.admanager.v1.EntitySignalsMapping;
import com.google.ads.admanager.v1.EntitySignalsMappingName;
import com.google.ads.admanager.v1.EntitySignalsMappingServiceSettings;
import com.google.ads.admanager.v1.GetEntitySignalsMappingRequest;
import com.google.ads.admanager.v1.ListEntitySignalsMappingsRequest;
import com.google.ads.admanager.v1.ListEntitySignalsMappingsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.UpdateEntitySignalsMappingRequest;
import com.google.ads.admanager.v1.stub.EntitySignalsMappingServiceStub;
import com.google.ads.admanager.v1.stub.EntitySignalsMappingServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EntitySignalsMappingServiceClient
implements BackgroundResource {
    private final EntitySignalsMappingServiceSettings settings;
    private final EntitySignalsMappingServiceStub stub;

    public static final EntitySignalsMappingServiceClient create() throws IOException {
        return EntitySignalsMappingServiceClient.create(EntitySignalsMappingServiceSettings.newBuilder().build());
    }

    public static final EntitySignalsMappingServiceClient create(EntitySignalsMappingServiceSettings settings) throws IOException {
        return new EntitySignalsMappingServiceClient(settings);
    }

    public static final EntitySignalsMappingServiceClient create(EntitySignalsMappingServiceStub stub) {
        return new EntitySignalsMappingServiceClient(stub);
    }

    protected EntitySignalsMappingServiceClient(EntitySignalsMappingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EntitySignalsMappingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected EntitySignalsMappingServiceClient(EntitySignalsMappingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final EntitySignalsMappingServiceSettings getSettings() {
        return this.settings;
    }

    public EntitySignalsMappingServiceStub getStub() {
        return this.stub;
    }

    public final EntitySignalsMapping getEntitySignalsMapping(EntitySignalsMappingName name) {
        GetEntitySignalsMappingRequest request = GetEntitySignalsMappingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntitySignalsMapping(request);
    }

    public final EntitySignalsMapping getEntitySignalsMapping(String name) {
        GetEntitySignalsMappingRequest request = GetEntitySignalsMappingRequest.newBuilder().setName(name).build();
        return this.getEntitySignalsMapping(request);
    }

    public final EntitySignalsMapping getEntitySignalsMapping(GetEntitySignalsMappingRequest request) {
        return (EntitySignalsMapping)this.getEntitySignalsMappingCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntitySignalsMappingRequest, EntitySignalsMapping> getEntitySignalsMappingCallable() {
        return this.stub.getEntitySignalsMappingCallable();
    }

    public final ListEntitySignalsMappingsPagedResponse listEntitySignalsMappings(NetworkName parent) {
        ListEntitySignalsMappingsRequest request = ListEntitySignalsMappingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntitySignalsMappings(request);
    }

    public final ListEntitySignalsMappingsPagedResponse listEntitySignalsMappings(String parent) {
        ListEntitySignalsMappingsRequest request = ListEntitySignalsMappingsRequest.newBuilder().setParent(parent).build();
        return this.listEntitySignalsMappings(request);
    }

    public final ListEntitySignalsMappingsPagedResponse listEntitySignalsMappings(ListEntitySignalsMappingsRequest request) {
        return (ListEntitySignalsMappingsPagedResponse)((Object)this.listEntitySignalsMappingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsPagedResponse> listEntitySignalsMappingsPagedCallable() {
        return this.stub.listEntitySignalsMappingsPagedCallable();
    }

    public final UnaryCallable<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse> listEntitySignalsMappingsCallable() {
        return this.stub.listEntitySignalsMappingsCallable();
    }

    public final EntitySignalsMapping createEntitySignalsMapping(NetworkName parent, EntitySignalsMapping entitySignalsMapping) {
        CreateEntitySignalsMappingRequest request = CreateEntitySignalsMappingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntitySignalsMapping(entitySignalsMapping).build();
        return this.createEntitySignalsMapping(request);
    }

    public final EntitySignalsMapping createEntitySignalsMapping(String parent, EntitySignalsMapping entitySignalsMapping) {
        CreateEntitySignalsMappingRequest request = CreateEntitySignalsMappingRequest.newBuilder().setParent(parent).setEntitySignalsMapping(entitySignalsMapping).build();
        return this.createEntitySignalsMapping(request);
    }

    public final EntitySignalsMapping createEntitySignalsMapping(CreateEntitySignalsMappingRequest request) {
        return (EntitySignalsMapping)this.createEntitySignalsMappingCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntitySignalsMappingRequest, EntitySignalsMapping> createEntitySignalsMappingCallable() {
        return this.stub.createEntitySignalsMappingCallable();
    }

    public final EntitySignalsMapping updateEntitySignalsMapping(EntitySignalsMapping entitySignalsMapping, FieldMask updateMask) {
        UpdateEntitySignalsMappingRequest request = UpdateEntitySignalsMappingRequest.newBuilder().setEntitySignalsMapping(entitySignalsMapping).setUpdateMask(updateMask).build();
        return this.updateEntitySignalsMapping(request);
    }

    public final EntitySignalsMapping updateEntitySignalsMapping(UpdateEntitySignalsMappingRequest request) {
        return (EntitySignalsMapping)this.updateEntitySignalsMappingCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEntitySignalsMappingRequest, EntitySignalsMapping> updateEntitySignalsMappingCallable() {
        return this.stub.updateEntitySignalsMappingCallable();
    }

    public final BatchCreateEntitySignalsMappingsResponse batchCreateEntitySignalsMappings(NetworkName parent, List<CreateEntitySignalsMappingRequest> requests) {
        BatchCreateEntitySignalsMappingsRequest request = BatchCreateEntitySignalsMappingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchCreateEntitySignalsMappings(request);
    }

    public final BatchCreateEntitySignalsMappingsResponse batchCreateEntitySignalsMappings(String parent, List<CreateEntitySignalsMappingRequest> requests) {
        BatchCreateEntitySignalsMappingsRequest request = BatchCreateEntitySignalsMappingsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchCreateEntitySignalsMappings(request);
    }

    public final BatchCreateEntitySignalsMappingsResponse batchCreateEntitySignalsMappings(BatchCreateEntitySignalsMappingsRequest request) {
        return (BatchCreateEntitySignalsMappingsResponse)this.batchCreateEntitySignalsMappingsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateEntitySignalsMappingsRequest, BatchCreateEntitySignalsMappingsResponse> batchCreateEntitySignalsMappingsCallable() {
        return this.stub.batchCreateEntitySignalsMappingsCallable();
    }

    public final BatchUpdateEntitySignalsMappingsResponse batchUpdateEntitySignalsMappings(NetworkName parent, List<UpdateEntitySignalsMappingRequest> requests) {
        BatchUpdateEntitySignalsMappingsRequest request = BatchUpdateEntitySignalsMappingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchUpdateEntitySignalsMappings(request);
    }

    public final BatchUpdateEntitySignalsMappingsResponse batchUpdateEntitySignalsMappings(String parent, List<UpdateEntitySignalsMappingRequest> requests) {
        BatchUpdateEntitySignalsMappingsRequest request = BatchUpdateEntitySignalsMappingsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchUpdateEntitySignalsMappings(request);
    }

    public final BatchUpdateEntitySignalsMappingsResponse batchUpdateEntitySignalsMappings(BatchUpdateEntitySignalsMappingsRequest request) {
        return (BatchUpdateEntitySignalsMappingsResponse)this.batchUpdateEntitySignalsMappingsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchUpdateEntitySignalsMappingsRequest, BatchUpdateEntitySignalsMappingsResponse> batchUpdateEntitySignalsMappingsCallable() {
        return this.stub.batchUpdateEntitySignalsMappingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEntitySignalsMappingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMapping, ListEntitySignalsMappingsPage, ListEntitySignalsMappingsFixedSizeCollection> {
        private ListEntitySignalsMappingsFixedSizeCollection(List<ListEntitySignalsMappingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntitySignalsMappingsFixedSizeCollection createEmptyCollection() {
            return new ListEntitySignalsMappingsFixedSizeCollection(null, 0);
        }

        protected ListEntitySignalsMappingsFixedSizeCollection createCollection(List<ListEntitySignalsMappingsPage> pages, int collectionSize) {
            return new ListEntitySignalsMappingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntitySignalsMappingsPage
    extends AbstractPage<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMapping, ListEntitySignalsMappingsPage> {
        private ListEntitySignalsMappingsPage(PageContext<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMapping> context, ListEntitySignalsMappingsResponse response) {
            super(context, (Object)response);
        }

        private static ListEntitySignalsMappingsPage createEmptyPage() {
            return new ListEntitySignalsMappingsPage(null, null);
        }

        protected ListEntitySignalsMappingsPage createPage(PageContext<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMapping> context, ListEntitySignalsMappingsResponse response) {
            return new ListEntitySignalsMappingsPage(context, response);
        }

        public ApiFuture<ListEntitySignalsMappingsPage> createPageAsync(PageContext<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMapping> context, ApiFuture<ListEntitySignalsMappingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntitySignalsMappingsPagedResponse
    extends AbstractPagedListResponse<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMapping, ListEntitySignalsMappingsPage, ListEntitySignalsMappingsFixedSizeCollection> {
        public static ApiFuture<ListEntitySignalsMappingsPagedResponse> createAsync(PageContext<ListEntitySignalsMappingsRequest, ListEntitySignalsMappingsResponse, EntitySignalsMapping> context, ApiFuture<ListEntitySignalsMappingsResponse> futureResponse) {
            ApiFuture<ListEntitySignalsMappingsPage> futurePage = ListEntitySignalsMappingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntitySignalsMappingsPagedResponse((ListEntitySignalsMappingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntitySignalsMappingsPagedResponse(ListEntitySignalsMappingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntitySignalsMappingsFixedSizeCollection.createEmptyCollection());
        }
    }
}

