/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetTaxonomyCategoryRequest;
import com.google.ads.admanager.v1.ListTaxonomyCategoriesRequest;
import com.google.ads.admanager.v1.ListTaxonomyCategoriesResponse;
import com.google.ads.admanager.v1.TaxonomyCategory;
import com.google.ads.admanager.v1.TaxonomyCategoryServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonTaxonomyCategoryServiceStub;
import com.google.ads.admanager.v1.stub.TaxonomyCategoryServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class TaxonomyCategoryServiceStubSettings
extends StubSettings<TaxonomyCategoryServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetTaxonomyCategoryRequest, TaxonomyCategory> getTaxonomyCategorySettings;
    private final PagedCallSettings<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategoryServiceClient.ListTaxonomyCategoriesPagedResponse> listTaxonomyCategoriesSettings;
    private static final PagedListDescriptor<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategory> LIST_TAXONOMY_CATEGORIES_PAGE_STR_DESC = new PagedListDescriptor<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategory>(){

        public String emptyToken() {
            return "";
        }

        public ListTaxonomyCategoriesRequest injectToken(ListTaxonomyCategoriesRequest payload, String token) {
            return ListTaxonomyCategoriesRequest.newBuilder((ListTaxonomyCategoriesRequest)payload).setPageToken(token).build();
        }

        public ListTaxonomyCategoriesRequest injectPageSize(ListTaxonomyCategoriesRequest payload, int pageSize) {
            return ListTaxonomyCategoriesRequest.newBuilder((ListTaxonomyCategoriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTaxonomyCategoriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTaxonomyCategoriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TaxonomyCategory> extractResources(ListTaxonomyCategoriesResponse payload) {
            return payload.getTaxonomyCategoriesList();
        }
    };
    private static final PagedListResponseFactory<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategoryServiceClient.ListTaxonomyCategoriesPagedResponse> LIST_TAXONOMY_CATEGORIES_PAGE_STR_FACT = new PagedListResponseFactory<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategoryServiceClient.ListTaxonomyCategoriesPagedResponse>(){

        public ApiFuture<TaxonomyCategoryServiceClient.ListTaxonomyCategoriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse> callable, ListTaxonomyCategoriesRequest request, ApiCallContext context, ApiFuture<ListTaxonomyCategoriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TAXONOMY_CATEGORIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TaxonomyCategoryServiceClient.ListTaxonomyCategoriesPagedResponse.createAsync((PageContext<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategory>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetTaxonomyCategoryRequest, TaxonomyCategory> getTaxonomyCategorySettings() {
        return this.getTaxonomyCategorySettings;
    }

    public PagedCallSettings<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategoryServiceClient.ListTaxonomyCategoriesPagedResponse> listTaxonomyCategoriesSettings() {
        return this.listTaxonomyCategoriesSettings;
    }

    public TaxonomyCategoryServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTaxonomyCategoryServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TaxonomyCategoryServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TaxonomyCategoryServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TaxonomyCategoryServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getTaxonomyCategorySettings = settingsBuilder.getTaxonomyCategorySettings().build();
        this.listTaxonomyCategoriesSettings = settingsBuilder.listTaxonomyCategoriesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TaxonomyCategoryServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetTaxonomyCategoryRequest, TaxonomyCategory> getTaxonomyCategorySettings;
        private final PagedCallSettings.Builder<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategoryServiceClient.ListTaxonomyCategoriesPagedResponse> listTaxonomyCategoriesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getTaxonomyCategorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTaxonomyCategoriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TAXONOMY_CATEGORIES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTaxonomyCategorySettings, this.listTaxonomyCategoriesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TaxonomyCategoryServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getTaxonomyCategorySettings = settings.getTaxonomyCategorySettings.toBuilder();
            this.listTaxonomyCategoriesSettings = settings.listTaxonomyCategoriesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTaxonomyCategorySettings, this.listTaxonomyCategoriesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TaxonomyCategoryServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TaxonomyCategoryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TaxonomyCategoryServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TaxonomyCategoryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getTaxonomyCategorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTaxonomyCategoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetTaxonomyCategoryRequest, TaxonomyCategory> getTaxonomyCategorySettings() {
            return this.getTaxonomyCategorySettings;
        }

        public PagedCallSettings.Builder<ListTaxonomyCategoriesRequest, ListTaxonomyCategoriesResponse, TaxonomyCategoryServiceClient.ListTaxonomyCategoriesPagedResponse> listTaxonomyCategoriesSettings() {
            return this.listTaxonomyCategoriesSettings;
        }

        public TaxonomyCategoryServiceStubSettings build() throws IOException {
            return new TaxonomyCategoryServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

