/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetPlacementRequest;
import com.google.ads.admanager.v1.ListPlacementsRequest;
import com.google.ads.admanager.v1.ListPlacementsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.Placement;
import com.google.ads.admanager.v1.PlacementName;
import com.google.ads.admanager.v1.PlacementServiceSettings;
import com.google.ads.admanager.v1.stub.PlacementServiceStub;
import com.google.ads.admanager.v1.stub.PlacementServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class PlacementServiceClient
implements BackgroundResource {
    private final PlacementServiceSettings settings;
    private final PlacementServiceStub stub;

    public static final PlacementServiceClient create() throws IOException {
        return PlacementServiceClient.create(PlacementServiceSettings.newBuilder().build());
    }

    public static final PlacementServiceClient create(PlacementServiceSettings settings) throws IOException {
        return new PlacementServiceClient(settings);
    }

    public static final PlacementServiceClient create(PlacementServiceStub stub) {
        return new PlacementServiceClient(stub);
    }

    protected PlacementServiceClient(PlacementServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PlacementServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected PlacementServiceClient(PlacementServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PlacementServiceSettings getSettings() {
        return this.settings;
    }

    public PlacementServiceStub getStub() {
        return this.stub;
    }

    public final Placement getPlacement(PlacementName name) {
        GetPlacementRequest request = GetPlacementRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPlacement(request);
    }

    public final Placement getPlacement(String name) {
        GetPlacementRequest request = GetPlacementRequest.newBuilder().setName(name).build();
        return this.getPlacement(request);
    }

    public final Placement getPlacement(GetPlacementRequest request) {
        return (Placement)this.getPlacementCallable().call((Object)request);
    }

    public final UnaryCallable<GetPlacementRequest, Placement> getPlacementCallable() {
        return this.stub.getPlacementCallable();
    }

    public final ListPlacementsPagedResponse listPlacements(NetworkName parent) {
        ListPlacementsRequest request = ListPlacementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPlacements(request);
    }

    public final ListPlacementsPagedResponse listPlacements(String parent) {
        ListPlacementsRequest request = ListPlacementsRequest.newBuilder().setParent(parent).build();
        return this.listPlacements(request);
    }

    public final ListPlacementsPagedResponse listPlacements(ListPlacementsRequest request) {
        return (ListPlacementsPagedResponse)((Object)this.listPlacementsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPlacementsRequest, ListPlacementsPagedResponse> listPlacementsPagedCallable() {
        return this.stub.listPlacementsPagedCallable();
    }

    public final UnaryCallable<ListPlacementsRequest, ListPlacementsResponse> listPlacementsCallable() {
        return this.stub.listPlacementsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPlacementsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPlacementsRequest, ListPlacementsResponse, Placement, ListPlacementsPage, ListPlacementsFixedSizeCollection> {
        private ListPlacementsFixedSizeCollection(List<ListPlacementsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPlacementsFixedSizeCollection createEmptyCollection() {
            return new ListPlacementsFixedSizeCollection(null, 0);
        }

        protected ListPlacementsFixedSizeCollection createCollection(List<ListPlacementsPage> pages, int collectionSize) {
            return new ListPlacementsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPlacementsPage
    extends AbstractPage<ListPlacementsRequest, ListPlacementsResponse, Placement, ListPlacementsPage> {
        private ListPlacementsPage(PageContext<ListPlacementsRequest, ListPlacementsResponse, Placement> context, ListPlacementsResponse response) {
            super(context, (Object)response);
        }

        private static ListPlacementsPage createEmptyPage() {
            return new ListPlacementsPage(null, null);
        }

        protected ListPlacementsPage createPage(PageContext<ListPlacementsRequest, ListPlacementsResponse, Placement> context, ListPlacementsResponse response) {
            return new ListPlacementsPage(context, response);
        }

        public ApiFuture<ListPlacementsPage> createPageAsync(PageContext<ListPlacementsRequest, ListPlacementsResponse, Placement> context, ApiFuture<ListPlacementsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPlacementsPagedResponse
    extends AbstractPagedListResponse<ListPlacementsRequest, ListPlacementsResponse, Placement, ListPlacementsPage, ListPlacementsFixedSizeCollection> {
        public static ApiFuture<ListPlacementsPagedResponse> createAsync(PageContext<ListPlacementsRequest, ListPlacementsResponse, Placement> context, ApiFuture<ListPlacementsResponse> futureResponse) {
            ApiFuture<ListPlacementsPage> futurePage = ListPlacementsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPlacementsPagedResponse((ListPlacementsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPlacementsPagedResponse(ListPlacementsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPlacementsFixedSizeCollection.createEmptyCollection());
        }
    }
}

