/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.CustomTargetingKey;
import com.google.ads.admanager.v1.CustomTargetingKeyName;
import com.google.ads.admanager.v1.CustomTargetingKeyServiceSettings;
import com.google.ads.admanager.v1.GetCustomTargetingKeyRequest;
import com.google.ads.admanager.v1.ListCustomTargetingKeysRequest;
import com.google.ads.admanager.v1.ListCustomTargetingKeysResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.stub.CustomTargetingKeyServiceStub;
import com.google.ads.admanager.v1.stub.CustomTargetingKeyServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CustomTargetingKeyServiceClient
implements BackgroundResource {
    private final CustomTargetingKeyServiceSettings settings;
    private final CustomTargetingKeyServiceStub stub;

    public static final CustomTargetingKeyServiceClient create() throws IOException {
        return CustomTargetingKeyServiceClient.create(CustomTargetingKeyServiceSettings.newBuilder().build());
    }

    public static final CustomTargetingKeyServiceClient create(CustomTargetingKeyServiceSettings settings) throws IOException {
        return new CustomTargetingKeyServiceClient(settings);
    }

    public static final CustomTargetingKeyServiceClient create(CustomTargetingKeyServiceStub stub) {
        return new CustomTargetingKeyServiceClient(stub);
    }

    protected CustomTargetingKeyServiceClient(CustomTargetingKeyServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomTargetingKeyServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomTargetingKeyServiceClient(CustomTargetingKeyServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomTargetingKeyServiceSettings getSettings() {
        return this.settings;
    }

    public CustomTargetingKeyServiceStub getStub() {
        return this.stub;
    }

    public final CustomTargetingKey getCustomTargetingKey(CustomTargetingKeyName name) {
        GetCustomTargetingKeyRequest request = GetCustomTargetingKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomTargetingKey(request);
    }

    public final CustomTargetingKey getCustomTargetingKey(String name) {
        GetCustomTargetingKeyRequest request = GetCustomTargetingKeyRequest.newBuilder().setName(name).build();
        return this.getCustomTargetingKey(request);
    }

    public final CustomTargetingKey getCustomTargetingKey(GetCustomTargetingKeyRequest request) {
        return (CustomTargetingKey)this.getCustomTargetingKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomTargetingKeyRequest, CustomTargetingKey> getCustomTargetingKeyCallable() {
        return this.stub.getCustomTargetingKeyCallable();
    }

    public final ListCustomTargetingKeysPagedResponse listCustomTargetingKeys(NetworkName parent) {
        ListCustomTargetingKeysRequest request = ListCustomTargetingKeysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCustomTargetingKeys(request);
    }

    public final ListCustomTargetingKeysPagedResponse listCustomTargetingKeys(String parent) {
        ListCustomTargetingKeysRequest request = ListCustomTargetingKeysRequest.newBuilder().setParent(parent).build();
        return this.listCustomTargetingKeys(request);
    }

    public final ListCustomTargetingKeysPagedResponse listCustomTargetingKeys(ListCustomTargetingKeysRequest request) {
        return (ListCustomTargetingKeysPagedResponse)((Object)this.listCustomTargetingKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomTargetingKeysRequest, ListCustomTargetingKeysPagedResponse> listCustomTargetingKeysPagedCallable() {
        return this.stub.listCustomTargetingKeysPagedCallable();
    }

    public final UnaryCallable<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse> listCustomTargetingKeysCallable() {
        return this.stub.listCustomTargetingKeysCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCustomTargetingKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKey, ListCustomTargetingKeysPage, ListCustomTargetingKeysFixedSizeCollection> {
        private ListCustomTargetingKeysFixedSizeCollection(List<ListCustomTargetingKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomTargetingKeysFixedSizeCollection createEmptyCollection() {
            return new ListCustomTargetingKeysFixedSizeCollection(null, 0);
        }

        protected ListCustomTargetingKeysFixedSizeCollection createCollection(List<ListCustomTargetingKeysPage> pages, int collectionSize) {
            return new ListCustomTargetingKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomTargetingKeysPage
    extends AbstractPage<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKey, ListCustomTargetingKeysPage> {
        private ListCustomTargetingKeysPage(PageContext<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKey> context, ListCustomTargetingKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomTargetingKeysPage createEmptyPage() {
            return new ListCustomTargetingKeysPage(null, null);
        }

        protected ListCustomTargetingKeysPage createPage(PageContext<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKey> context, ListCustomTargetingKeysResponse response) {
            return new ListCustomTargetingKeysPage(context, response);
        }

        public ApiFuture<ListCustomTargetingKeysPage> createPageAsync(PageContext<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKey> context, ApiFuture<ListCustomTargetingKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomTargetingKeysPagedResponse
    extends AbstractPagedListResponse<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKey, ListCustomTargetingKeysPage, ListCustomTargetingKeysFixedSizeCollection> {
        public static ApiFuture<ListCustomTargetingKeysPagedResponse> createAsync(PageContext<ListCustomTargetingKeysRequest, ListCustomTargetingKeysResponse, CustomTargetingKey> context, ApiFuture<ListCustomTargetingKeysResponse> futureResponse) {
            ApiFuture<ListCustomTargetingKeysPage> futurePage = ListCustomTargetingKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomTargetingKeysPagedResponse((ListCustomTargetingKeysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomTargetingKeysPagedResponse(ListCustomTargetingKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomTargetingKeysFixedSizeCollection.createEmptyCollection());
        }
    }
}

