/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.CreateReportRequest;
import com.google.ads.admanager.v1.FetchReportResultRowsRequest;
import com.google.ads.admanager.v1.FetchReportResultRowsResponse;
import com.google.ads.admanager.v1.GetReportRequest;
import com.google.ads.admanager.v1.ListReportsRequest;
import com.google.ads.admanager.v1.ListReportsResponse;
import com.google.ads.admanager.v1.NetworkName;
import com.google.ads.admanager.v1.Report;
import com.google.ads.admanager.v1.ReportName;
import com.google.ads.admanager.v1.ReportServiceSettings;
import com.google.ads.admanager.v1.RunReportMetadata;
import com.google.ads.admanager.v1.RunReportRequest;
import com.google.ads.admanager.v1.RunReportResponse;
import com.google.ads.admanager.v1.UpdateReportRequest;
import com.google.ads.admanager.v1.stub.ReportServiceStub;
import com.google.ads.admanager.v1.stub.ReportServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ReportServiceClient
implements BackgroundResource {
    private final ReportServiceSettings settings;
    private final ReportServiceStub stub;
    private final OperationsClient httpJsonOperationsClient;

    public static final ReportServiceClient create() throws IOException {
        return ReportServiceClient.create(ReportServiceSettings.newBuilder().build());
    }

    public static final ReportServiceClient create(ReportServiceSettings settings) throws IOException {
        return new ReportServiceClient(settings);
    }

    public static final ReportServiceClient create(ReportServiceStub stub) {
        return new ReportServiceClient(stub);
    }

    protected ReportServiceClient(ReportServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ReportServiceStubSettings)settings.getStubSettings()).createStub();
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ReportServiceClient(ReportServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.httpJsonOperationsClient = OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ReportServiceSettings getSettings() {
        return this.settings;
    }

    public ReportServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Report getReport(ReportName name) {
        GetReportRequest request = GetReportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReport(request);
    }

    public final Report getReport(String name) {
        GetReportRequest request = GetReportRequest.newBuilder().setName(name).build();
        return this.getReport(request);
    }

    public final Report getReport(GetReportRequest request) {
        return (Report)this.getReportCallable().call((Object)request);
    }

    public final UnaryCallable<GetReportRequest, Report> getReportCallable() {
        return this.stub.getReportCallable();
    }

    public final ListReportsPagedResponse listReports(NetworkName parent) {
        ListReportsRequest request = ListReportsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReports(request);
    }

    public final ListReportsPagedResponse listReports(String parent) {
        ListReportsRequest request = ListReportsRequest.newBuilder().setParent(parent).build();
        return this.listReports(request);
    }

    public final ListReportsPagedResponse listReports(ListReportsRequest request) {
        return (ListReportsPagedResponse)((Object)this.listReportsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReportsRequest, ListReportsPagedResponse> listReportsPagedCallable() {
        return this.stub.listReportsPagedCallable();
    }

    public final UnaryCallable<ListReportsRequest, ListReportsResponse> listReportsCallable() {
        return this.stub.listReportsCallable();
    }

    public final Report createReport(NetworkName parent, Report report) {
        CreateReportRequest request = CreateReportRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReport(report).build();
        return this.createReport(request);
    }

    public final Report createReport(String parent, Report report) {
        CreateReportRequest request = CreateReportRequest.newBuilder().setParent(parent).setReport(report).build();
        return this.createReport(request);
    }

    public final Report createReport(CreateReportRequest request) {
        return (Report)this.createReportCallable().call((Object)request);
    }

    public final UnaryCallable<CreateReportRequest, Report> createReportCallable() {
        return this.stub.createReportCallable();
    }

    public final Report updateReport(Report report, FieldMask updateMask) {
        UpdateReportRequest request = UpdateReportRequest.newBuilder().setReport(report).setUpdateMask(updateMask).build();
        return this.updateReport(request);
    }

    public final Report updateReport(UpdateReportRequest request) {
        return (Report)this.updateReportCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateReportRequest, Report> updateReportCallable() {
        return this.stub.updateReportCallable();
    }

    public final OperationFuture<RunReportResponse, RunReportMetadata> runReportAsync(ReportName name) {
        RunReportRequest request = RunReportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.runReportAsync(request);
    }

    public final OperationFuture<RunReportResponse, RunReportMetadata> runReportAsync(String name) {
        RunReportRequest request = RunReportRequest.newBuilder().setName(name).build();
        return this.runReportAsync(request);
    }

    public final OperationFuture<RunReportResponse, RunReportMetadata> runReportAsync(RunReportRequest request) {
        return this.runReportOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RunReportRequest, RunReportResponse, RunReportMetadata> runReportOperationCallable() {
        return this.stub.runReportOperationCallable();
    }

    public final UnaryCallable<RunReportRequest, Operation> runReportCallable() {
        return this.stub.runReportCallable();
    }

    public final FetchReportResultRowsPagedResponse fetchReportResultRows(String name) {
        FetchReportResultRowsRequest request = FetchReportResultRowsRequest.newBuilder().setName(name).build();
        return this.fetchReportResultRows(request);
    }

    public final FetchReportResultRowsPagedResponse fetchReportResultRows(FetchReportResultRowsRequest request) {
        return (FetchReportResultRowsPagedResponse)((Object)this.fetchReportResultRowsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchReportResultRowsRequest, FetchReportResultRowsPagedResponse> fetchReportResultRowsPagedCallable() {
        return this.stub.fetchReportResultRowsPagedCallable();
    }

    public final UnaryCallable<FetchReportResultRowsRequest, FetchReportResultRowsResponse> fetchReportResultRowsCallable() {
        return this.stub.fetchReportResultRowsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class FetchReportResultRowsFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchReportResultRowsRequest, FetchReportResultRowsResponse, Report.DataTable.Row, FetchReportResultRowsPage, FetchReportResultRowsFixedSizeCollection> {
        private FetchReportResultRowsFixedSizeCollection(List<FetchReportResultRowsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchReportResultRowsFixedSizeCollection createEmptyCollection() {
            return new FetchReportResultRowsFixedSizeCollection(null, 0);
        }

        protected FetchReportResultRowsFixedSizeCollection createCollection(List<FetchReportResultRowsPage> pages, int collectionSize) {
            return new FetchReportResultRowsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchReportResultRowsPage
    extends AbstractPage<FetchReportResultRowsRequest, FetchReportResultRowsResponse, Report.DataTable.Row, FetchReportResultRowsPage> {
        private FetchReportResultRowsPage(PageContext<FetchReportResultRowsRequest, FetchReportResultRowsResponse, Report.DataTable.Row> context, FetchReportResultRowsResponse response) {
            super(context, (Object)response);
        }

        private static FetchReportResultRowsPage createEmptyPage() {
            return new FetchReportResultRowsPage(null, null);
        }

        protected FetchReportResultRowsPage createPage(PageContext<FetchReportResultRowsRequest, FetchReportResultRowsResponse, Report.DataTable.Row> context, FetchReportResultRowsResponse response) {
            return new FetchReportResultRowsPage(context, response);
        }

        public ApiFuture<FetchReportResultRowsPage> createPageAsync(PageContext<FetchReportResultRowsRequest, FetchReportResultRowsResponse, Report.DataTable.Row> context, ApiFuture<FetchReportResultRowsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchReportResultRowsPagedResponse
    extends AbstractPagedListResponse<FetchReportResultRowsRequest, FetchReportResultRowsResponse, Report.DataTable.Row, FetchReportResultRowsPage, FetchReportResultRowsFixedSizeCollection> {
        public static ApiFuture<FetchReportResultRowsPagedResponse> createAsync(PageContext<FetchReportResultRowsRequest, FetchReportResultRowsResponse, Report.DataTable.Row> context, ApiFuture<FetchReportResultRowsResponse> futureResponse) {
            ApiFuture<FetchReportResultRowsPage> futurePage = FetchReportResultRowsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchReportResultRowsPagedResponse((FetchReportResultRowsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchReportResultRowsPagedResponse(FetchReportResultRowsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchReportResultRowsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReportsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReportsRequest, ListReportsResponse, Report, ListReportsPage, ListReportsFixedSizeCollection> {
        private ListReportsFixedSizeCollection(List<ListReportsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReportsFixedSizeCollection createEmptyCollection() {
            return new ListReportsFixedSizeCollection(null, 0);
        }

        protected ListReportsFixedSizeCollection createCollection(List<ListReportsPage> pages, int collectionSize) {
            return new ListReportsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReportsPage
    extends AbstractPage<ListReportsRequest, ListReportsResponse, Report, ListReportsPage> {
        private ListReportsPage(PageContext<ListReportsRequest, ListReportsResponse, Report> context, ListReportsResponse response) {
            super(context, (Object)response);
        }

        private static ListReportsPage createEmptyPage() {
            return new ListReportsPage(null, null);
        }

        protected ListReportsPage createPage(PageContext<ListReportsRequest, ListReportsResponse, Report> context, ListReportsResponse response) {
            return new ListReportsPage(context, response);
        }

        public ApiFuture<ListReportsPage> createPageAsync(PageContext<ListReportsRequest, ListReportsResponse, Report> context, ApiFuture<ListReportsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReportsPagedResponse
    extends AbstractPagedListResponse<ListReportsRequest, ListReportsResponse, Report, ListReportsPage, ListReportsFixedSizeCollection> {
        public static ApiFuture<ListReportsPagedResponse> createAsync(PageContext<ListReportsRequest, ListReportsResponse, Report> context, ApiFuture<ListReportsResponse> futureResponse) {
            ApiFuture<ListReportsPage> futurePage = ListReportsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReportsPagedResponse((ListReportsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReportsPagedResponse(ListReportsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReportsFixedSizeCollection.createEmptyCollection());
        }
    }
}

