/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.CreateReportRequest;
import com.google.ads.admanager.v1.FetchReportResultRowsRequest;
import com.google.ads.admanager.v1.FetchReportResultRowsResponse;
import com.google.ads.admanager.v1.GetReportRequest;
import com.google.ads.admanager.v1.ListReportsRequest;
import com.google.ads.admanager.v1.ListReportsResponse;
import com.google.ads.admanager.v1.Report;
import com.google.ads.admanager.v1.ReportServiceClient;
import com.google.ads.admanager.v1.RunReportMetadata;
import com.google.ads.admanager.v1.RunReportRequest;
import com.google.ads.admanager.v1.RunReportResponse;
import com.google.ads.admanager.v1.UpdateReportRequest;
import com.google.ads.admanager.v1.stub.HttpJsonReportServiceStub;
import com.google.ads.admanager.v1.stub.ReportServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ReportServiceStubSettings
extends StubSettings<ReportServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetReportRequest, Report> getReportSettings;
    private final PagedCallSettings<ListReportsRequest, ListReportsResponse, ReportServiceClient.ListReportsPagedResponse> listReportsSettings;
    private final UnaryCallSettings<CreateReportRequest, Report> createReportSettings;
    private final UnaryCallSettings<UpdateReportRequest, Report> updateReportSettings;
    private final UnaryCallSettings<RunReportRequest, Operation> runReportSettings;
    private final OperationCallSettings<RunReportRequest, RunReportResponse, RunReportMetadata> runReportOperationSettings;
    private final PagedCallSettings<FetchReportResultRowsRequest, FetchReportResultRowsResponse, ReportServiceClient.FetchReportResultRowsPagedResponse> fetchReportResultRowsSettings;
    private static final PagedListDescriptor<ListReportsRequest, ListReportsResponse, Report> LIST_REPORTS_PAGE_STR_DESC = new PagedListDescriptor<ListReportsRequest, ListReportsResponse, Report>(){

        public String emptyToken() {
            return "";
        }

        public ListReportsRequest injectToken(ListReportsRequest payload, String token) {
            return ListReportsRequest.newBuilder((ListReportsRequest)payload).setPageToken(token).build();
        }

        public ListReportsRequest injectPageSize(ListReportsRequest payload, int pageSize) {
            return ListReportsRequest.newBuilder((ListReportsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListReportsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListReportsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Report> extractResources(ListReportsResponse payload) {
            return payload.getReportsList();
        }
    };
    private static final PagedListDescriptor<FetchReportResultRowsRequest, FetchReportResultRowsResponse, Report.DataTable.Row> FETCH_REPORT_RESULT_ROWS_PAGE_STR_DESC = new PagedListDescriptor<FetchReportResultRowsRequest, FetchReportResultRowsResponse, Report.DataTable.Row>(){

        public String emptyToken() {
            return "";
        }

        public FetchReportResultRowsRequest injectToken(FetchReportResultRowsRequest payload, String token) {
            return FetchReportResultRowsRequest.newBuilder((FetchReportResultRowsRequest)payload).setPageToken(token).build();
        }

        public FetchReportResultRowsRequest injectPageSize(FetchReportResultRowsRequest payload, int pageSize) {
            return FetchReportResultRowsRequest.newBuilder((FetchReportResultRowsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchReportResultRowsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchReportResultRowsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Report.DataTable.Row> extractResources(FetchReportResultRowsResponse payload) {
            return payload.getRowsList();
        }
    };
    private static final PagedListResponseFactory<ListReportsRequest, ListReportsResponse, ReportServiceClient.ListReportsPagedResponse> LIST_REPORTS_PAGE_STR_FACT = new PagedListResponseFactory<ListReportsRequest, ListReportsResponse, ReportServiceClient.ListReportsPagedResponse>(){

        public ApiFuture<ReportServiceClient.ListReportsPagedResponse> getFuturePagedResponse(UnaryCallable<ListReportsRequest, ListReportsResponse> callable, ListReportsRequest request, ApiCallContext context, ApiFuture<ListReportsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REPORTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReportServiceClient.ListReportsPagedResponse.createAsync((PageContext<ListReportsRequest, ListReportsResponse, Report>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<FetchReportResultRowsRequest, FetchReportResultRowsResponse, ReportServiceClient.FetchReportResultRowsPagedResponse> FETCH_REPORT_RESULT_ROWS_PAGE_STR_FACT = new PagedListResponseFactory<FetchReportResultRowsRequest, FetchReportResultRowsResponse, ReportServiceClient.FetchReportResultRowsPagedResponse>(){

        public ApiFuture<ReportServiceClient.FetchReportResultRowsPagedResponse> getFuturePagedResponse(UnaryCallable<FetchReportResultRowsRequest, FetchReportResultRowsResponse> callable, FetchReportResultRowsRequest request, ApiCallContext context, ApiFuture<FetchReportResultRowsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_REPORT_RESULT_ROWS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReportServiceClient.FetchReportResultRowsPagedResponse.createAsync((PageContext<FetchReportResultRowsRequest, FetchReportResultRowsResponse, Report.DataTable.Row>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetReportRequest, Report> getReportSettings() {
        return this.getReportSettings;
    }

    public PagedCallSettings<ListReportsRequest, ListReportsResponse, ReportServiceClient.ListReportsPagedResponse> listReportsSettings() {
        return this.listReportsSettings;
    }

    public UnaryCallSettings<CreateReportRequest, Report> createReportSettings() {
        return this.createReportSettings;
    }

    public UnaryCallSettings<UpdateReportRequest, Report> updateReportSettings() {
        return this.updateReportSettings;
    }

    public UnaryCallSettings<RunReportRequest, Operation> runReportSettings() {
        return this.runReportSettings;
    }

    public OperationCallSettings<RunReportRequest, RunReportResponse, RunReportMetadata> runReportOperationSettings() {
        return this.runReportOperationSettings;
    }

    public PagedCallSettings<FetchReportResultRowsRequest, FetchReportResultRowsResponse, ReportServiceClient.FetchReportResultRowsPagedResponse> fetchReportResultRowsSettings() {
        return this.fetchReportResultRowsSettings;
    }

    public ReportServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonReportServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ReportServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReportServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ReportServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getReportSettings = settingsBuilder.getReportSettings().build();
        this.listReportsSettings = settingsBuilder.listReportsSettings().build();
        this.createReportSettings = settingsBuilder.createReportSettings().build();
        this.updateReportSettings = settingsBuilder.updateReportSettings().build();
        this.runReportSettings = settingsBuilder.runReportSettings().build();
        this.runReportOperationSettings = settingsBuilder.runReportOperationSettings().build();
        this.fetchReportResultRowsSettings = settingsBuilder.fetchReportResultRowsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ReportServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetReportRequest, Report> getReportSettings;
        private final PagedCallSettings.Builder<ListReportsRequest, ListReportsResponse, ReportServiceClient.ListReportsPagedResponse> listReportsSettings;
        private final UnaryCallSettings.Builder<CreateReportRequest, Report> createReportSettings;
        private final UnaryCallSettings.Builder<UpdateReportRequest, Report> updateReportSettings;
        private final UnaryCallSettings.Builder<RunReportRequest, Operation> runReportSettings;
        private final OperationCallSettings.Builder<RunReportRequest, RunReportResponse, RunReportMetadata> runReportOperationSettings;
        private final PagedCallSettings.Builder<FetchReportResultRowsRequest, FetchReportResultRowsResponse, ReportServiceClient.FetchReportResultRowsPagedResponse> fetchReportResultRowsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listReportsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REPORTS_PAGE_STR_FACT);
            this.createReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runReportOperationSettings = OperationCallSettings.newBuilder();
            this.fetchReportResultRowsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_REPORT_RESULT_ROWS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getReportSettings, this.listReportsSettings, this.createReportSettings, this.updateReportSettings, this.runReportSettings, this.fetchReportResultRowsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ReportServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getReportSettings = settings.getReportSettings.toBuilder();
            this.listReportsSettings = settings.listReportsSettings.toBuilder();
            this.createReportSettings = settings.createReportSettings.toBuilder();
            this.updateReportSettings = settings.updateReportSettings.toBuilder();
            this.runReportSettings = settings.runReportSettings.toBuilder();
            this.runReportOperationSettings = settings.runReportOperationSettings.toBuilder();
            this.fetchReportResultRowsSettings = settings.fetchReportResultRowsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getReportSettings, this.listReportsSettings, this.createReportSettings, this.updateReportSettings, this.runReportSettings, this.fetchReportResultRowsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ReportServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ReportServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReportServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ReportServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listReportsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.runReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.fetchReportResultRowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.runReportOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RunReportResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RunReportMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetReportRequest, Report> getReportSettings() {
            return this.getReportSettings;
        }

        public PagedCallSettings.Builder<ListReportsRequest, ListReportsResponse, ReportServiceClient.ListReportsPagedResponse> listReportsSettings() {
            return this.listReportsSettings;
        }

        public UnaryCallSettings.Builder<CreateReportRequest, Report> createReportSettings() {
            return this.createReportSettings;
        }

        public UnaryCallSettings.Builder<UpdateReportRequest, Report> updateReportSettings() {
            return this.updateReportSettings;
        }

        public UnaryCallSettings.Builder<RunReportRequest, Operation> runReportSettings() {
            return this.runReportSettings;
        }

        public OperationCallSettings.Builder<RunReportRequest, RunReportResponse, RunReportMetadata> runReportOperationSettings() {
            return this.runReportOperationSettings;
        }

        public PagedCallSettings.Builder<FetchReportResultRowsRequest, FetchReportResultRowsResponse, ReportServiceClient.FetchReportResultRowsPagedResponse> fetchReportResultRowsSettings() {
            return this.fetchReportResultRowsSettings;
        }

        public ReportServiceStubSettings build() throws IOException {
            return new ReportServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

