/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetTeamRequest;
import com.google.ads.admanager.v1.ListTeamsRequest;
import com.google.ads.admanager.v1.ListTeamsResponse;
import com.google.ads.admanager.v1.Team;
import com.google.ads.admanager.v1.TeamServiceClient;
import com.google.ads.admanager.v1.stub.HttpJsonTeamServiceStub;
import com.google.ads.admanager.v1.stub.TeamServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class TeamServiceStubSettings
extends StubSettings<TeamServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetTeamRequest, Team> getTeamSettings;
    private final PagedCallSettings<ListTeamsRequest, ListTeamsResponse, TeamServiceClient.ListTeamsPagedResponse> listTeamsSettings;
    private static final PagedListDescriptor<ListTeamsRequest, ListTeamsResponse, Team> LIST_TEAMS_PAGE_STR_DESC = new PagedListDescriptor<ListTeamsRequest, ListTeamsResponse, Team>(){

        public String emptyToken() {
            return "";
        }

        public ListTeamsRequest injectToken(ListTeamsRequest payload, String token) {
            return ListTeamsRequest.newBuilder((ListTeamsRequest)payload).setPageToken(token).build();
        }

        public ListTeamsRequest injectPageSize(ListTeamsRequest payload, int pageSize) {
            return ListTeamsRequest.newBuilder((ListTeamsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTeamsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTeamsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Team> extractResources(ListTeamsResponse payload) {
            return payload.getTeamsList();
        }
    };
    private static final PagedListResponseFactory<ListTeamsRequest, ListTeamsResponse, TeamServiceClient.ListTeamsPagedResponse> LIST_TEAMS_PAGE_STR_FACT = new PagedListResponseFactory<ListTeamsRequest, ListTeamsResponse, TeamServiceClient.ListTeamsPagedResponse>(){

        public ApiFuture<TeamServiceClient.ListTeamsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTeamsRequest, ListTeamsResponse> callable, ListTeamsRequest request, ApiCallContext context, ApiFuture<ListTeamsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TEAMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TeamServiceClient.ListTeamsPagedResponse.createAsync((PageContext<ListTeamsRequest, ListTeamsResponse, Team>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetTeamRequest, Team> getTeamSettings() {
        return this.getTeamSettings;
    }

    public PagedCallSettings<ListTeamsRequest, ListTeamsResponse, TeamServiceClient.ListTeamsPagedResponse> listTeamsSettings() {
        return this.listTeamsSettings;
    }

    public TeamServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTeamServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TeamServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TeamServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TeamServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getTeamSettings = settingsBuilder.getTeamSettings().build();
        this.listTeamsSettings = settingsBuilder.listTeamsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TeamServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetTeamRequest, Team> getTeamSettings;
        private final PagedCallSettings.Builder<ListTeamsRequest, ListTeamsResponse, TeamServiceClient.ListTeamsPagedResponse> listTeamsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getTeamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTeamsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TEAMS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTeamSettings, this.listTeamsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TeamServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getTeamSettings = settings.getTeamSettings.toBuilder();
            this.listTeamsSettings = settings.listTeamsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTeamSettings, this.listTeamsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TeamServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TeamServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TeamServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TeamServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getTeamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTeamsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetTeamRequest, Team> getTeamSettings() {
            return this.getTeamSettings;
        }

        public PagedCallSettings.Builder<ListTeamsRequest, ListTeamsResponse, TeamServiceClient.ListTeamsPagedResponse> listTeamsSettings() {
            return this.listTeamsSettings;
        }

        public TeamServiceStubSettings build() throws IOException {
            return new TeamServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

