/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.GetLineItemRequest;
import com.google.ads.admanager.v1.LineItem;
import com.google.ads.admanager.v1.LineItemServiceClient;
import com.google.ads.admanager.v1.ListLineItemsRequest;
import com.google.ads.admanager.v1.ListLineItemsResponse;
import com.google.ads.admanager.v1.stub.HttpJsonLineItemServiceStub;
import com.google.ads.admanager.v1.stub.LineItemServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class LineItemServiceStubSettings
extends StubSettings<LineItemServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final UnaryCallSettings<GetLineItemRequest, LineItem> getLineItemSettings;
    private final PagedCallSettings<ListLineItemsRequest, ListLineItemsResponse, LineItemServiceClient.ListLineItemsPagedResponse> listLineItemsSettings;
    private static final PagedListDescriptor<ListLineItemsRequest, ListLineItemsResponse, LineItem> LIST_LINE_ITEMS_PAGE_STR_DESC = new PagedListDescriptor<ListLineItemsRequest, ListLineItemsResponse, LineItem>(){

        public String emptyToken() {
            return "";
        }

        public ListLineItemsRequest injectToken(ListLineItemsRequest payload, String token) {
            return ListLineItemsRequest.newBuilder((ListLineItemsRequest)payload).setPageToken(token).build();
        }

        public ListLineItemsRequest injectPageSize(ListLineItemsRequest payload, int pageSize) {
            return ListLineItemsRequest.newBuilder((ListLineItemsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLineItemsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLineItemsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LineItem> extractResources(ListLineItemsResponse payload) {
            return payload.getLineItemsList();
        }
    };
    private static final PagedListResponseFactory<ListLineItemsRequest, ListLineItemsResponse, LineItemServiceClient.ListLineItemsPagedResponse> LIST_LINE_ITEMS_PAGE_STR_FACT = new PagedListResponseFactory<ListLineItemsRequest, ListLineItemsResponse, LineItemServiceClient.ListLineItemsPagedResponse>(){

        public ApiFuture<LineItemServiceClient.ListLineItemsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLineItemsRequest, ListLineItemsResponse> callable, ListLineItemsRequest request, ApiCallContext context, ApiFuture<ListLineItemsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LINE_ITEMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LineItemServiceClient.ListLineItemsPagedResponse.createAsync((PageContext<ListLineItemsRequest, ListLineItemsResponse, LineItem>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetLineItemRequest, LineItem> getLineItemSettings() {
        return this.getLineItemSettings;
    }

    public PagedCallSettings<ListLineItemsRequest, ListLineItemsResponse, LineItemServiceClient.ListLineItemsPagedResponse> listLineItemsSettings() {
        return this.listLineItemsSettings;
    }

    public LineItemServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonLineItemServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "admanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "admanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "admanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return LineItemServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LineItemServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected LineItemServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getLineItemSettings = settingsBuilder.getLineItemSettings().build();
        this.listLineItemsSettings = settingsBuilder.listLineItemsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<LineItemServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetLineItemRequest, LineItem> getLineItemSettings;
        private final PagedCallSettings.Builder<ListLineItemsRequest, ListLineItemsResponse, LineItemServiceClient.ListLineItemsPagedResponse> listLineItemsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getLineItemSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLineItemsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LINE_ITEMS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getLineItemSettings, this.listLineItemsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(LineItemServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getLineItemSettings = settings.getLineItemSettings.toBuilder();
            this.listLineItemsSettings = settings.listLineItemsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getLineItemSettings, this.listLineItemsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(LineItemServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)LineItemServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LineItemServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LineItemServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getLineItemSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLineItemsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetLineItemRequest, LineItem> getLineItemSettings() {
            return this.getLineItemSettings;
        }

        public PagedCallSettings.Builder<ListLineItemsRequest, ListLineItemsResponse, LineItemServiceClient.ListLineItemsPagedResponse> listLineItemsSettings() {
            return this.listLineItemsSettings;
        }

        public LineItemServiceStubSettings build() throws IOException {
            return new LineItemServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

