/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1.stub;

import com.google.ads.admanager.v1.Creative;
import com.google.ads.admanager.v1.CreativeServiceClient;
import com.google.ads.admanager.v1.GetCreativeRequest;
import com.google.ads.admanager.v1.ListCreativesRequest;
import com.google.ads.admanager.v1.ListCreativesResponse;
import com.google.ads.admanager.v1.stub.CreativeServiceStub;
import com.google.ads.admanager.v1.stub.CreativeServiceStubSettings;
import com.google.ads.admanager.v1.stub.HttpJsonCreativeServiceCallableFactory;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonCreativeServiceStub
extends CreativeServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetCreativeRequest, Creative> getCreativeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.CreativeService/GetCreative").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=networks/*/creatives/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Creative.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListCreativesRequest, ListCreativesResponse> listCreativesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.ads.admanager.v1.CreativeService/ListCreatives").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=networks/*}/creatives", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "skip", (Object)request.getSkip());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCreativesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetCreativeRequest, Creative> getCreativeCallable;
    private final UnaryCallable<ListCreativesRequest, ListCreativesResponse> listCreativesCallable;
    private final UnaryCallable<ListCreativesRequest, CreativeServiceClient.ListCreativesPagedResponse> listCreativesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCreativeServiceStub create(CreativeServiceStubSettings settings) throws IOException {
        return new HttpJsonCreativeServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCreativeServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCreativeServiceStub(CreativeServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonCreativeServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCreativeServiceStub(CreativeServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCreativeServiceStub(CreativeServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCreativeServiceCallableFactory());
    }

    protected HttpJsonCreativeServiceStub(CreativeServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getCreativeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCreativeMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listCreativesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCreativesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getCreativeCallable = callableFactory.createUnaryCallable(getCreativeTransportSettings, settings.getCreativeSettings(), clientContext);
        this.listCreativesCallable = callableFactory.createUnaryCallable(listCreativesTransportSettings, settings.listCreativesSettings(), clientContext);
        this.listCreativesPagedCallable = callableFactory.createPagedCallable(listCreativesTransportSettings, settings.listCreativesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getCreativeMethodDescriptor);
        methodDescriptors.add(listCreativesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetCreativeRequest, Creative> getCreativeCallable() {
        return this.getCreativeCallable;
    }

    @Override
    public UnaryCallable<ListCreativesRequest, ListCreativesResponse> listCreativesCallable() {
        return this.listCreativesCallable;
    }

    @Override
    public UnaryCallable<ListCreativesRequest, CreativeServiceClient.ListCreativesPagedResponse> listCreativesPagedCallable() {
        return this.listCreativesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

