/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.admanager.v1;

import com.google.ads.admanager.v1.GetLineItemRequest;
import com.google.ads.admanager.v1.LineItem;
import com.google.ads.admanager.v1.LineItemName;
import com.google.ads.admanager.v1.LineItemServiceSettings;
import com.google.ads.admanager.v1.ListLineItemsRequest;
import com.google.ads.admanager.v1.ListLineItemsResponse;
import com.google.ads.admanager.v1.OrderName;
import com.google.ads.admanager.v1.stub.LineItemServiceStub;
import com.google.ads.admanager.v1.stub.LineItemServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class LineItemServiceClient
implements BackgroundResource {
    private final LineItemServiceSettings settings;
    private final LineItemServiceStub stub;

    public static final LineItemServiceClient create() throws IOException {
        return LineItemServiceClient.create(LineItemServiceSettings.newBuilder().build());
    }

    public static final LineItemServiceClient create(LineItemServiceSettings settings) throws IOException {
        return new LineItemServiceClient(settings);
    }

    public static final LineItemServiceClient create(LineItemServiceStub stub) {
        return new LineItemServiceClient(stub);
    }

    protected LineItemServiceClient(LineItemServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LineItemServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected LineItemServiceClient(LineItemServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LineItemServiceSettings getSettings() {
        return this.settings;
    }

    public LineItemServiceStub getStub() {
        return this.stub;
    }

    public final LineItem getLineItem(LineItemName name) {
        GetLineItemRequest request = GetLineItemRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLineItem(request);
    }

    public final LineItem getLineItem(String name) {
        GetLineItemRequest request = GetLineItemRequest.newBuilder().setName(name).build();
        return this.getLineItem(request);
    }

    public final LineItem getLineItem(GetLineItemRequest request) {
        return (LineItem)this.getLineItemCallable().call((Object)request);
    }

    public final UnaryCallable<GetLineItemRequest, LineItem> getLineItemCallable() {
        return this.stub.getLineItemCallable();
    }

    public final ListLineItemsPagedResponse listLineItems(OrderName parent) {
        ListLineItemsRequest request = ListLineItemsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLineItems(request);
    }

    public final ListLineItemsPagedResponse listLineItems(String parent) {
        ListLineItemsRequest request = ListLineItemsRequest.newBuilder().setParent(parent).build();
        return this.listLineItems(request);
    }

    public final ListLineItemsPagedResponse listLineItems(ListLineItemsRequest request) {
        return (ListLineItemsPagedResponse)((Object)this.listLineItemsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLineItemsRequest, ListLineItemsPagedResponse> listLineItemsPagedCallable() {
        return this.stub.listLineItemsPagedCallable();
    }

    public final UnaryCallable<ListLineItemsRequest, ListLineItemsResponse> listLineItemsCallable() {
        return this.stub.listLineItemsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLineItemsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLineItemsRequest, ListLineItemsResponse, LineItem, ListLineItemsPage, ListLineItemsFixedSizeCollection> {
        private ListLineItemsFixedSizeCollection(List<ListLineItemsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLineItemsFixedSizeCollection createEmptyCollection() {
            return new ListLineItemsFixedSizeCollection(null, 0);
        }

        protected ListLineItemsFixedSizeCollection createCollection(List<ListLineItemsPage> pages, int collectionSize) {
            return new ListLineItemsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLineItemsPage
    extends AbstractPage<ListLineItemsRequest, ListLineItemsResponse, LineItem, ListLineItemsPage> {
        private ListLineItemsPage(PageContext<ListLineItemsRequest, ListLineItemsResponse, LineItem> context, ListLineItemsResponse response) {
            super(context, (Object)response);
        }

        private static ListLineItemsPage createEmptyPage() {
            return new ListLineItemsPage(null, null);
        }

        protected ListLineItemsPage createPage(PageContext<ListLineItemsRequest, ListLineItemsResponse, LineItem> context, ListLineItemsResponse response) {
            return new ListLineItemsPage(context, response);
        }

        public ApiFuture<ListLineItemsPage> createPageAsync(PageContext<ListLineItemsRequest, ListLineItemsResponse, LineItem> context, ApiFuture<ListLineItemsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLineItemsPagedResponse
    extends AbstractPagedListResponse<ListLineItemsRequest, ListLineItemsResponse, LineItem, ListLineItemsPage, ListLineItemsFixedSizeCollection> {
        public static ApiFuture<ListLineItemsPagedResponse> createAsync(PageContext<ListLineItemsRequest, ListLineItemsResponse, LineItem> context, ApiFuture<ListLineItemsResponse> futureResponse) {
            ApiFuture<ListLineItemsPage> futurePage = ListLineItemsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLineItemsPagedResponse((ListLineItemsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLineItemsPagedResponse(ListLineItemsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLineItemsFixedSizeCollection.createEmptyCollection());
        }
    }
}

