/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.provider;

import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PaymentResult {
    private static final String TAG = "PaymentResult";

    public static PaymentResult failure(String reason) {
        return new Failure(reason);
    }

    public static PaymentResult success(String purchaseToken) {
        return new Success(purchaseToken);
    }

    public abstract int getActivityResult();

    public abstract void log();

    public final String getDetails() {
        try {
            return this.toJson().toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract JSONObject toJson() throws JSONException;

    private static class Failure
    extends PaymentResult {
        private final String mError;

        private Failure(String error) {
            this.mError = error;
        }

        @Override
        public int getActivityResult() {
            return 0;
        }

        @Override
        public void log() {
            Log.w((String)PaymentResult.TAG, (String)this.mError);
        }

        @Override
        protected JSONObject toJson() throws JSONException {
            JSONObject obj = new JSONObject();
            obj.put("error", (Object)this.mError);
            return obj;
        }
    }

    private static class Success
    extends PaymentResult {
        private final String mPurchaseToken;

        private Success(String purchaseToken) {
            this.mPurchaseToken = purchaseToken;
        }

        @Override
        public int getActivityResult() {
            return -1;
        }

        @Override
        public void log() {
            Log.d((String)PaymentResult.TAG, (String)"Payment successful");
        }

        @Override
        protected JSONObject toJson() throws JSONException {
            JSONObject obj = new JSONObject();
            obj.put("token", (Object)this.mPurchaseToken);
            return obj;
        }
    }
}

