/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.provider;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.SkuDetails;
import com.google.androidbrowserhelper.playbilling.digitalgoods.BillingResultMerger;
import com.google.androidbrowserhelper.playbilling.provider.BillingWrapper;
import com.google.androidbrowserhelper.playbilling.provider.BillingWrapperFactory;
import com.google.androidbrowserhelper.playbilling.provider.MethodData;
import com.google.androidbrowserhelper.playbilling.provider.PaymentResult;
import com.google.androidbrowserhelper.playbilling.provider.PaymentVerifier;
import java.util.Collections;
import java.util.List;

public class PaymentActivity
extends Activity
implements BillingWrapper.Listener {
    private static final String TAG = "PaymentActivity";
    private static final String METHOD_NAME = "https://play.google.com/billing";
    static final String PROXY_PACKAGE_KEY = "PROXY_PACKAGE";
    private BillingWrapper mWrapper;
    private MethodData mMethodData;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ComponentName component = this.getCallingActivity();
        if (component == null) {
            this.fail("Must be launched with startActivityForResult.");
            return;
        }
        if (!PaymentVerifier.shouldAllowPayments((Context)this, component.getPackageName(), TAG)) {
            this.fail("Launching app is not verified.");
            return;
        }
        this.getIntent().putExtra(PROXY_PACKAGE_KEY, component.getPackageName());
        this.mMethodData = MethodData.fromIntent(this.getIntent());
        if (this.mMethodData == null) {
            this.fail("Could not parse SKU.");
            return;
        }
        this.mWrapper = BillingWrapperFactory.get((Context)this, this);
        this.mWrapper.connect(new BillingClientStateListener(){

            public void onBillingSetupFinished(BillingResult billingResult) {
                PaymentActivity.this.onConnected();
            }

            public void onBillingServiceDisconnected() {
                PaymentActivity.this.onDisconnected();
            }
        });
    }

    public void onDisconnected() {
        this.fail("BillingClient disconnected.");
    }

    public void onConnected() {
        BillingResultMerger merger = new BillingResultMerger((result, details) -> {
            if (details == null || details.isEmpty()) {
                this.fail("Play Billing returned did not find SKUs.");
                return;
            }
            if (this.mWrapper.launchPaymentFlow(this, (SkuDetails)details.get(0), this.mMethodData)) {
                return;
            }
            this.fail("Payment attempt failed (have you already bought the item?).");
        });
        List<String> ids = Collections.singletonList(this.mMethodData.sku);
        this.mWrapper.querySkuDetails("inapp", ids, merger::setInAppResult);
        this.mWrapper.querySkuDetails("subs", ids, merger::setSubsResult);
    }

    @Override
    public void onPurchaseFlowComplete(BillingResult result, String purchaseToken) {
        if (result.getResponseCode() == 0) {
            this.setResultAndFinish(PaymentResult.success(purchaseToken));
        } else {
            this.fail("Purchase flow ended with result: " + result);
        }
    }

    private void fail(String reason) {
        this.setResultAndFinish(PaymentResult.failure(reason));
    }

    private void setResultAndFinish(PaymentResult result) {
        result.log();
        Intent intent = new Intent();
        intent.putExtra("methodName", METHOD_NAME);
        intent.putExtra("details", result.getDetails());
        this.setResult(result.getActivityResult(), intent);
        this.finish();
    }
}

