/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.provider;

import android.app.Activity;
import android.content.Intent;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.google.androidbrowserhelper.playbilling.provider.BillingWrapper;
import com.google.androidbrowserhelper.playbilling.provider.MethodData;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MockBillingWrapper
implements BillingWrapper {
    private BillingWrapper.Listener mListener;
    private BillingClientStateListener mConnectionStateListener;
    private List<String> mQueriedSkuDetails;
    private boolean mPaymentFlowSuccessful;
    private SkuDetailsResponseListener mPendingQueryInAppSkuDetailsCallback;
    private SkuDetailsResponseListener mPendingQuerySubsSkuDetailsCallback;
    private BillingWrapper.QueryPurchasesListener mPendingQueryInAppPurchaseDetailsCallback;
    private BillingWrapper.QueryPurchasesListener mPendingQuerySubsPurchaseDetailsCallback;
    private String mAcknowledgeToken;
    private AcknowledgePurchaseResponseListener mPendingAcknowledgeCallback;
    private String mConsumeToken;
    private ConsumeResponseListener mPendingConsumeCallback;
    private Intent mPlayBillingFlowLaunchIntent;
    private final CountDownLatch mConnectLatch = new CountDownLatch(1);
    private final CountDownLatch mLaunchPaymentFlowLatch = new CountDownLatch(1);
    private final CountDownLatch mQuerySkuDetailsLatch = new CountDownLatch(2);
    private final CountDownLatch mQueryPurchasesLatch = new CountDownLatch(2);

    @Override
    public void connect(BillingClientStateListener callback) {
        this.mConnectionStateListener = callback;
        this.mConnectLatch.countDown();
    }

    @Override
    public void querySkuDetails(String skuType, List<String> skus, SkuDetailsResponseListener callback) {
        this.mQueriedSkuDetails = skus;
        this.mQuerySkuDetailsLatch.countDown();
        if ("inapp".equals(skuType)) {
            this.mPendingQueryInAppSkuDetailsCallback = callback;
        } else {
            this.mPendingQuerySubsSkuDetailsCallback = callback;
        }
    }

    @Override
    public void queryPurchases(String skuType, BillingWrapper.QueryPurchasesListener callback) {
        this.mQueryPurchasesLatch.countDown();
        if ("inapp".equals(skuType)) {
            this.mPendingQueryInAppPurchaseDetailsCallback = callback;
        } else {
            this.mPendingQuerySubsPurchaseDetailsCallback = callback;
        }
    }

    @Override
    public void acknowledge(String token, AcknowledgePurchaseResponseListener callback) {
        this.mAcknowledgeToken = token;
        this.mPendingAcknowledgeCallback = callback;
    }

    @Override
    public void consume(String token, ConsumeResponseListener callback) {
        this.mConsumeToken = token;
        this.mPendingConsumeCallback = callback;
    }

    @Override
    public boolean launchPaymentFlow(Activity activity, SkuDetails sku, MethodData data) {
        this.mPlayBillingFlowLaunchIntent = activity.getIntent();
        this.mLaunchPaymentFlowLatch.countDown();
        return this.mPaymentFlowSuccessful;
    }

    public void triggerConnected() {
        this.mConnectionStateListener.onBillingSetupFinished(MockBillingWrapper.toResult(0));
    }

    public void triggerDisconnected() {
        this.mConnectionStateListener.onBillingServiceDisconnected();
    }

    public void triggerOnGotSkuDetails(List<SkuDetails> skuDetails) {
        this.triggerOnGotInAppSkuDetails(skuDetails);
        this.triggerOnGotSubsSkuDetails(Collections.emptyList());
    }

    public void triggerOnGotInAppSkuDetails(List<SkuDetails> skuDetails) {
        this.triggerOnGotInAppSkuDetails(0, skuDetails);
    }

    public void triggerOnGotInAppSkuDetails(int responseCode, List<SkuDetails> skuDetails) {
        this.mPendingQueryInAppSkuDetailsCallback.onSkuDetailsResponse(MockBillingWrapper.toResult(responseCode), skuDetails);
    }

    public void triggerOnGotSubsSkuDetails(List<SkuDetails> skuDetails) {
        this.triggerOnGotSubsSkuDetails(0, skuDetails);
    }

    public void triggerOnGotSubsSkuDetails(int responseCode, List<SkuDetails> skuDetails) {
        this.mPendingQuerySubsSkuDetailsCallback.onSkuDetailsResponse(MockBillingWrapper.toResult(responseCode), skuDetails);
    }

    public void triggerOnGotInAppPurchaseDetails(List<Purchase> details) {
        Purchase.PurchasesResult result = new Purchase.PurchasesResult(MockBillingWrapper.toResult(0), details);
        this.mPendingQueryInAppPurchaseDetailsCallback.onQueryPurchasesResponse(result);
    }

    public void triggerOnGotSubsPurchaseDetails(List<Purchase> details) {
        Purchase.PurchasesResult result = new Purchase.PurchasesResult(MockBillingWrapper.toResult(0), details);
        this.mPendingQuerySubsPurchaseDetailsCallback.onQueryPurchasesResponse(result);
    }

    public void triggerAcknowledge(int responseCode) {
        this.mPendingAcknowledgeCallback.onAcknowledgePurchaseResponse(MockBillingWrapper.toResult(responseCode));
    }

    public void triggerConsume(int responseCode, String token) {
        this.mPendingConsumeCallback.onConsumeResponse(MockBillingWrapper.toResult(responseCode), token);
    }

    public void triggerOnPurchasesUpdated() {
        this.mListener.onPurchaseFlowComplete(MockBillingWrapper.toResult(0), "");
    }

    public boolean waitForConnect() throws InterruptedException {
        return MockBillingWrapper.wait(this.mConnectLatch);
    }

    public boolean waitForQuerySkuDetails() throws InterruptedException {
        return MockBillingWrapper.wait(this.mQuerySkuDetailsLatch);
    }

    public boolean waitForLaunchPaymentFlow() throws InterruptedException {
        return MockBillingWrapper.wait(this.mLaunchPaymentFlowLatch);
    }

    public boolean waitForQueryPurchases() throws InterruptedException {
        return MockBillingWrapper.wait(this.mQueryPurchasesLatch);
    }

    public void setListener(BillingWrapper.Listener listener) {
        this.mListener = listener;
    }

    public void setPaymentFlowWillBeSuccessful(boolean successful) {
        this.mPaymentFlowSuccessful = successful;
    }

    public List<String> getQueriedSkuDetails() {
        return this.mQueriedSkuDetails;
    }

    public String getConsumeToken() {
        return this.mConsumeToken;
    }

    public String getAcknowledgeToken() {
        return this.mAcknowledgeToken;
    }

    public Intent getPlayBillingFlowLaunchIntent() {
        return this.mPlayBillingFlowLaunchIntent;
    }

    private static boolean wait(CountDownLatch latch) throws InterruptedException {
        return latch.await(5L, TimeUnit.SECONDS);
    }

    private static BillingResult toResult(int responseCode) {
        return BillingResult.newBuilder().setResponseCode(responseCode).build();
    }
}

