/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidbrowserhelper.playbilling.digitalgoods;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.SkuDetails;
import com.google.androidbrowserhelper.playbilling.digitalgoods.BillingResultMerger;
import com.google.androidbrowserhelper.playbilling.digitalgoods.DigitalGoodsCallback;
import com.google.androidbrowserhelper.playbilling.digitalgoods.DigitalGoodsConverter;
import com.google.androidbrowserhelper.playbilling.digitalgoods.ItemDetails;
import com.google.androidbrowserhelper.playbilling.digitalgoods.Logging;
import com.google.androidbrowserhelper.playbilling.provider.BillingWrapper;
import java.util.Arrays;
import java.util.List;

public class GetDetailsCall {
    public static final String COMMAND_NAME = "getDetails";
    static final String PARAM_GET_DETAILS_ITEM_IDS = "getDetails.itemIds";
    static final String RESPONSE_GET_DETAILS = "getDetails.response";
    static final String RESPONSE_GET_DETAILS_RESPONSE_CODE = "getDetails.responseCode";
    static final String RESPONSE_GET_DETAILS_DETAILS_LIST = "getDetails.detailsList";
    private final List<String> mItemIds;
    private final DigitalGoodsCallback mCallback;

    private GetDetailsCall(List<String> itemIds, DigitalGoodsCallback callback) {
        this.mItemIds = itemIds;
        this.mCallback = callback;
    }

    @Nullable
    public static GetDetailsCall create(@Nullable Bundle args, @Nullable DigitalGoodsCallback callback) {
        if (args == null || callback == null) {
            return null;
        }
        String[] itemIds = args.getStringArray(PARAM_GET_DETAILS_ITEM_IDS);
        if (itemIds == null) {
            return null;
        }
        return new GetDetailsCall(Arrays.asList(itemIds), callback);
    }

    private void respond(BillingResult result, @Nullable List<SkuDetails> detailsList) {
        Logging.logGetDetailsResponse(result);
        Parcelable[] parcelables = new Parcelable[]{};
        if (detailsList != null) {
            parcelables = new Parcelable[detailsList.size()];
            int index = 0;
            for (SkuDetails details : detailsList) {
                parcelables[index++] = ItemDetails.create(details).toBundle();
            }
        }
        Bundle args = new Bundle();
        args.putInt(RESPONSE_GET_DETAILS_RESPONSE_CODE, DigitalGoodsConverter.toChromiumResponseCode(result));
        args.putParcelableArray(RESPONSE_GET_DETAILS_DETAILS_LIST, parcelables);
        this.mCallback.run(RESPONSE_GET_DETAILS, args);
    }

    public void call(BillingWrapper billing) {
        Logging.logGetDetailsCall(this.mItemIds);
        BillingResultMerger merger = new BillingResultMerger(this::respond);
        billing.querySkuDetails("inapp", this.mItemIds, merger::setInAppResult);
        billing.querySkuDetails("subs", this.mItemIds, merger::setSubsResult);
    }

    static Bundle createBundleForTesting(String ... itemIds) {
        Bundle bundle = new Bundle();
        bundle.putStringArray(PARAM_GET_DETAILS_ITEM_IDS, itemIds);
        return bundle;
    }
}

