/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.dynamic.zzh;
import com.google.android.gms.internal.zzafm;
import com.google.android.gms.internal.zzafn;
import com.google.android.gms.internal.zzafu;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb aNS;
    private boolean mCreated = false;
    private final zzh aNT = zzh.zza((Fragment)this);
    private final zzc aNU = new zzc();
    private zza aNV = new zza(this);
    private final Fragment Ov = this;
    private WalletFragmentOptions aNW;
    private WalletFragmentInitParams aNX;
    private MaskedWalletRequest aNY;
    private MaskedWallet aNZ;
    private Boolean aOa;

    public static SupportWalletFragment newInstance(WalletFragmentOptions walletFragmentOptions) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)walletFragmentOptions);
        supportWalletFragment.Ov.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams walletFragmentInitParams) {
        if (this.aNS != null) {
            this.aNS.initialize(walletFragmentInitParams);
            this.aNX = null;
        } else if (this.aNX == null) {
            this.aNX = walletFragmentInitParams;
            if (this.aNY != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.aNZ != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
        if (this.aNS != null) {
            this.aNS.updateMaskedWalletRequest(maskedWalletRequest);
            this.aNY = null;
        } else {
            this.aNY = maskedWalletRequest;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.aNS != null) {
            this.aNS.updateMaskedWallet(maskedWallet);
            this.aNZ = null;
        } else {
            this.aNZ = maskedWallet;
        }
    }

    public void setEnabled(boolean bl) {
        if (this.aNS != null) {
            this.aNS.setEnabled(bl);
            this.aOa = null;
        } else {
            this.aOa = bl;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.aNV.zza(onStateChangedListener);
    }

    public int getState() {
        return this.aNS != null ? this.aNS.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        if (this.aNW == null) {
            this.aNW = WalletFragmentOptions.zzc((Context)activity, attributeSet);
        }
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.aNW);
        this.aNU.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(bundle);
        if (bundle != null) {
            bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)bundle.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.aNX != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.aNX = walletFragmentInitParams;
            }
            if (this.aNY == null) {
                this.aNY = (MaskedWalletRequest)bundle.getParcelable("maskedWalletRequest");
            }
            if (this.aNZ == null) {
                this.aNZ = (MaskedWallet)bundle.getParcelable("maskedWallet");
            }
            if (bundle.containsKey("walletFragmentOptions")) {
                this.aNW = (WalletFragmentOptions)bundle.getParcelable("walletFragmentOptions");
            }
            if (bundle.containsKey("enabled")) {
                this.aOa = bundle.getBoolean("enabled");
            }
        } else if (this.Ov.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.Ov.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzen((Context)this.Ov.getActivity());
            this.aNW = walletFragmentOptions;
        }
        this.mCreated = true;
        this.aNU.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return this.aNU.onCreateView(layoutInflater, viewGroup, bundle);
    }

    public void onStart() {
        super.onStart();
        this.aNU.onStart();
    }

    public void onResume() {
        super.onResume();
        this.aNU.onResume();
        FragmentManager fragmentManager = this.Ov.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.Ov.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.Ov.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.aNU.onPause();
    }

    public void onStop() {
        super.onStop();
        this.aNU.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.aNU.onSaveInstanceState(bundle);
        if (this.aNX != null) {
            bundle.putParcelable("walletFragmentInitParams", (Parcelable)this.aNX);
            this.aNX = null;
        }
        if (this.aNY != null) {
            bundle.putParcelable("maskedWalletRequest", (Parcelable)this.aNY);
            this.aNY = null;
        }
        if (this.aNZ != null) {
            bundle.putParcelable("maskedWallet", (Parcelable)this.aNZ);
            this.aNZ = null;
        }
        if (this.aNW != null) {
            bundle.putParcelable("walletFragmentOptions", (Parcelable)this.aNW);
            this.aNW = null;
        }
        if (this.aOa != null) {
            bundle.putBoolean("enabled", this.aOa.booleanValue());
            this.aOa = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        if (this.aNS != null) {
            this.aNS.onActivityResult(n, n2, intent);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzafn.zza {
        private OnStateChangedListener aOb;
        private final SupportWalletFragment aOc;

        zza(SupportWalletFragment supportWalletFragment) {
            this.aOc = supportWalletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.aOb != null) {
                this.aOb.onStateChanged(this.aOc, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.aOb = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzafm aOd;

        private zzb(zzafm zzafm2) {
            this.aOd = zzafm2;
        }

        private void initialize(WalletFragmentInitParams walletFragmentInitParams) {
            try {
                this.aOd.initialize(walletFragmentInitParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean bl) {
            try {
                this.aOd.setEnabled(bl);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest maskedWalletRequest) {
            try {
                this.aOd.updateMaskedWalletRequest(maskedWalletRequest);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.aOd.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.aOd.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)bundle.getParcelable("extraWalletFragmentOptions");
            try {
                this.aOd.zza(zze.zzac((Object)activity), walletFragmentOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                this.aOd.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            try {
                zzd zzd2 = this.aOd.onCreateView(zze.zzac((Object)layoutInflater), zze.zzac((Object)viewGroup), bundle);
                return (View)zze.zzae((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.aOd.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.aOd.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.aOd.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.aOd.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.aOd.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int n, int n2, Intent intent) {
            try {
                this.aOd.onActivityResult(n, n2, intent);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.Ov.getActivity();
            if (SupportWalletFragment.this.aNS == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    zzafm zzafm2 = zzafu.zza((Activity)fragmentActivity, (com.google.android.gms.dynamic.zzc)SupportWalletFragment.this.aNT, SupportWalletFragment.this.aNW, SupportWalletFragment.this.aNV);
                    SupportWalletFragment.this.aNS = new zzb(zzafm2);
                    SupportWalletFragment.this.aNW = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)SupportWalletFragment.this.aNS);
                if (SupportWalletFragment.this.aNX != null) {
                    SupportWalletFragment.this.aNS.initialize(SupportWalletFragment.this.aNX);
                    SupportWalletFragment.this.aNX = null;
                }
                if (SupportWalletFragment.this.aNY != null) {
                    SupportWalletFragment.this.aNS.updateMaskedWalletRequest(SupportWalletFragment.this.aNY);
                    SupportWalletFragment.this.aNY = null;
                }
                if (SupportWalletFragment.this.aNZ != null) {
                    SupportWalletFragment.this.aNS.updateMaskedWallet(SupportWalletFragment.this.aNZ);
                    SupportWalletFragment.this.aNZ = null;
                }
                if (SupportWalletFragment.this.aOa != null) {
                    SupportWalletFragment.this.aNS.setEnabled(SupportWalletFragment.this.aOa);
                    SupportWalletFragment.this.aOa = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.Ov.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (SupportWalletFragment.this.aNW != null && (walletFragmentStyle = SupportWalletFragment.this.aNW.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.Ov.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, -1);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, -2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.Ov.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)fragmentActivity, (int)-1);
        }
    }
}

