/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzaek;
import com.google.android.gms.internal.zzael;
import com.google.android.gms.internal.zzaen;
import com.google.android.gms.internal.zzaeo;
import com.google.android.gms.internal.zzpr;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.wobs.zzj;
import java.util.Locale;

public final class Wallet {
    private static final Api.zzf<zzael> bN = new Api.zzf();
    private static final Api.zza<zzael, WalletOptions> bO = new Api.zza<zzael, WalletOptions>(){

        public zzael zza(Context context, Looper looper, zzg zzg2, WalletOptions walletOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            WalletOptions walletOptions2 = walletOptions != null ? walletOptions : new WalletOptions();
            return new zzael(context, looper, zzg2, connectionCallbacks, onConnectionFailedListener, walletOptions2.environment, walletOptions2.theme, walletOptions2.aHG);
        }
    };
    public static final Api<WalletOptions> API = new Api("Wallet.API", bO, bN);
    public static final Payments Payments = new zzaek();
    public static final zzj aHE = new zzaeo();
    public static final com.google.android.gms.wallet.firstparty.zza aHF = new zzaen();

    @Deprecated
    public static void checkForPreAuthorization(GoogleApiClient googleApiClient, int n) {
        Payments.checkForPreAuthorization(googleApiClient, n);
    }

    @Deprecated
    public static void loadMaskedWallet(GoogleApiClient googleApiClient, MaskedWalletRequest maskedWalletRequest, int n) {
        Payments.loadMaskedWallet(googleApiClient, maskedWalletRequest, n);
    }

    @Deprecated
    public static void loadFullWallet(GoogleApiClient googleApiClient, FullWalletRequest fullWalletRequest, int n) {
        Payments.loadFullWallet(googleApiClient, fullWalletRequest, n);
    }

    @Deprecated
    public static void changeMaskedWallet(GoogleApiClient googleApiClient, String string, String string2, int n) {
        Payments.changeMaskedWallet(googleApiClient, string, string2, n);
    }

    @Deprecated
    public static void notifyTransactionStatus(GoogleApiClient googleApiClient, NotifyTransactionStatusRequest notifyTransactionStatusRequest) {
        Payments.notifyTransactionStatus(googleApiClient, notifyTransactionStatusRequest);
    }

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected Status zzb(Status status) {
            return status;
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    public static abstract class zza<R extends Result>
    extends zzpr.zza<R, zzael> {
        public zza(GoogleApiClient googleApiClient) {
            super(API, googleApiClient);
        }
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasOptions {
        public final int environment;
        public final int theme;
        private final boolean aHG;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.aHH;
            this.theme = builder.mTheme;
            this.aHG = builder.aHI;
        }

        public static final class Builder {
            private int aHH = 3;
            private int mTheme = 0;
            private boolean aHI = true;

            public Builder setEnvironment(int n) {
                if (n != 0 && n != 2 && n != 1 && n != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.aHH = n;
                return this;
            }

            public Builder setTheme(int n) {
                if (n != 0 && n != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", n);
                    throw new IllegalArgumentException(string);
                }
                this.mTheme = n;
                return this;
            }

            @Deprecated
            public Builder useGoogleWallet() {
                this.aHI = false;
                return this;
            }

            public WalletOptions build() {
                return new WalletOptions(this);
            }
        }
    }
}

