/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.internal.zzsn;
import com.google.android.gms.internal.zzso;
import com.google.android.gms.internal.zzsv;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class WalletFragment
extends Fragment {
    private zzb zzbla;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.zzb zzblb = com.google.android.gms.dynamic.zzb.zza((Fragment)this);
    private final zzc zzblc = new zzc();
    private zza zzbld = new zza(this);
    private final Fragment zzatC = this;
    private WalletFragmentOptions zzbkR;
    private WalletFragmentInitParams zzbkS;
    private MaskedWalletRequest zzbkT;
    private MaskedWallet zzbkU;
    private Boolean zzbkV;

    public static WalletFragment newInstance(WalletFragmentOptions options) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        walletFragment.zzatC.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.zzbla != null) {
            this.zzbla.initialize(initParams);
            this.zzbkS = null;
        } else if (this.zzbkS == null) {
            this.zzbkS = initParams;
            if (this.zzbkT != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzbkU != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.zzbla != null) {
            this.zzbla.updateMaskedWalletRequest(request);
            this.zzbkT = null;
        } else {
            this.zzbkT = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzbla != null) {
            this.zzbla.updateMaskedWallet(maskedWallet);
            this.zzbkU = null;
        } else {
            this.zzbkU = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.zzbla != null) {
            this.zzbla.setEnabled(enabled);
            this.zzbkV = null;
        } else {
            this.zzbkV = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.zzbld.zza(listener);
    }

    public int getState() {
        return this.zzbla != null ? this.zzbla.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.zzbkR == null) {
            this.zzbkR = WalletFragmentOptions.zzb((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzbkR);
        this.zzblc.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzbkS != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzbkS = walletFragmentInitParams;
            }
            if (this.zzbkT == null) {
                this.zzbkT = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.zzbkU == null) {
                this.zzbkU = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.zzbkR = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.zzbkV = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.zzatC.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzatC.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzbc((Context)this.zzatC.getActivity());
            this.zzbkR = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzblc.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.zzblc.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.zzblc.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzblc.onResume();
        FragmentManager fragmentManager = this.zzatC.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzatC.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzatC.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzblc.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzblc.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzblc.onSaveInstanceState(outState);
        if (this.zzbkS != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.zzbkS);
            this.zzbkS = null;
        }
        if (this.zzbkT != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.zzbkT);
            this.zzbkT = null;
        }
        if (this.zzbkU != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.zzbkU);
            this.zzbkU = null;
        }
        if (this.zzbkR != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.zzbkR);
            this.zzbkR = null;
        }
        if (this.zzbkV != null) {
            outState.putBoolean("enabled", this.zzbkV.booleanValue());
            this.zzbkV = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.zzbla != null) {
            this.zzbla.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzso.zza {
        private OnStateChangedListener zzble;
        private final WalletFragment zzblf;

        zza(WalletFragment walletFragment) {
            this.zzblf = walletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzble != null) {
                this.zzble.onStateChanged(this.zzblf, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzble = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzsn zzbkY;

        private zzb(zzsn zzsn2) {
            this.zzbkY = zzsn2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.zzbkY.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.zzbkY.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.zzbkY.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzbkY.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzbkY.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzbkY.zza(zze.zzB((Object)activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzbkY.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                zzd zzd2 = this.zzbkY.onCreateView(zze.zzB((Object)inflater), zze.zzB((Object)container), savedInstanceState);
                return (View)zze.zzp((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzbkY.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzbkY.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzbkY.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzbkY.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzbkY.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.zzbkY.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            Activity activity = WalletFragment.this.zzatC.getActivity();
            if (WalletFragment.this.zzbla == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    zzsn zzsn2 = zzsv.zza(activity, (com.google.android.gms.dynamic.zzc)WalletFragment.this.zzblb, WalletFragment.this.zzbkR, WalletFragment.this.zzbld);
                    WalletFragment.this.zzbla = new zzb(zzsn2);
                    WalletFragment.this.zzbkR = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)WalletFragment.this.zzbla);
                if (WalletFragment.this.zzbkS != null) {
                    WalletFragment.this.zzbla.initialize(WalletFragment.this.zzbkS);
                    WalletFragment.this.zzbkS = null;
                }
                if (WalletFragment.this.zzbkT != null) {
                    WalletFragment.this.zzbla.updateMaskedWalletRequest(WalletFragment.this.zzbkT);
                    WalletFragment.this.zzbkT = null;
                }
                if (WalletFragment.this.zzbkU != null) {
                    WalletFragment.this.zzbla.updateMaskedWallet(WalletFragment.this.zzbkU);
                    WalletFragment.this.zzbkU = null;
                }
                if (WalletFragment.this.zzbkV != null) {
                    WalletFragment.this.zzbla.setEnabled(WalletFragment.this.zzbkV);
                    WalletFragment.this.zzbkV = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.zzatC.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (WalletFragment.this.zzbkR != null && (walletFragmentStyle = WalletFragment.this.zzbkR.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.zzatC.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, n);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, n2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.zzatC.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)activity, (int)-1);
        }
    }
}

