/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.wallet.zzab;
import com.google.android.gms.internal.wallet.zzr;
import com.google.android.gms.internal.wallet.zzz;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.WalletObjectsClient;
import com.google.android.gms.wallet.wobs.WalletObjects;
import com.google.android.gms.wallet.zzap;
import com.google.android.gms.wallet.zzar;
import java.util.Locale;

public final class Wallet {
    @NonNull
    public static final Api<WalletOptions> API;
    private static final Api.ClientKey zzd;
    private static final Api.AbstractClientBuilder zze;
    @NonNull
    public static final WalletObjects zza;
    @Deprecated
    public static final zzr zzb;
    @ShowFirstParty
    public static final zzz zzc;

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static PaymentsClient getPaymentsClient(@NonNull Activity activity, @NonNull WalletOptions options) {
        void var1_1;
        Activity activity2;
        return new PaymentsClient(activity2, (WalletOptions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static PaymentsClient getPaymentsClient(@NonNull Context context, @NonNull WalletOptions options) {
        void var1_1;
        Context context2;
        return new PaymentsClient(context2, (WalletOptions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static WalletObjectsClient getWalletObjectsClient(@NonNull Activity activity, @Nullable WalletOptions options) {
        void var1_1;
        Activity activity2;
        return new WalletObjectsClient(activity2, (WalletOptions)var1_1);
    }

    static {
        zzd = new Api.ClientKey();
        zze = new zzap();
        API = new Api("Wallet.API", zze, zzd);
        zzb = new zzr();
        zza = new zzab();
        zzc = new zzz();
    }

    private Wallet() {
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasAccountOptions {
        public final int environment;
        public final int theme;
        @ShowFirstParty
        @NonNull
        public final Account zza;
        @VisibleForTesting
        final boolean zzb;

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.environment, this.theme, null, this.zzb});
        }

        @NonNull
        public Account getAccount() {
            return null;
        }

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zza;
            this.theme = builder.zzb;
            this.zzb = builder.zzc;
            this.zza = null;
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof WalletOptions) {
                WalletOptions walletOptions;
                walletOptions = walletOptions;
                if (Objects.equal((Object)this.environment, (Object)walletOptions.environment) && Objects.equal((Object)this.theme, (Object)walletOptions.theme)) {
                    Account cfr_ignored_0 = walletOptions.zza;
                    if (Objects.equal(null, null) && Objects.equal((Object)this.zzb, (Object)walletOptions.zzb)) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        /* synthetic */ WalletOptions(zzar zzar2) {
            this(new Builder());
        }

        /* synthetic */ WalletOptions(Builder builder, zzar zzar2) {
            this(builder);
        }

        public static final class Builder {
            private int zza = 3;
            private int zzb = 1;
            private boolean zzc = true;

            /*
             * Enabled aggressive block sorting
             */
            @NonNull
            public Builder setEnvironment(int environment) {
                int n;
                if (environment != false) {
                    if (n != 0) {
                        if (n != 2 && n != 1 && n != 23 && n != 3) {
                            Object[] objectArray = new Object[]{n};
                            String string = String.format(Locale.US, "Invalid environment value %d", objectArray);
                            throw new IllegalArgumentException(string);
                        }
                    } else {
                        n = 0;
                    }
                }
                this.zza = n;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setTheme(int theme) {
                void var1_1;
                if (theme != 0 && var1_1 != true && var1_1 != 2 && var1_1 != 3) {
                    Object object = new Object[]{(int)var1_1};
                    object = String.format(Locale.US, "Invalid theme value %d", object);
                    throw new IllegalArgumentException((String)object);
                }
                object.zzb = var1_1;
                return object;
            }

            @Deprecated
            @NonNull
            public Builder useGoogleWallet() {
                this.zzc = false;
                return this;
            }

            @NonNull
            public WalletOptions build() {
                return new WalletOptions(this, null);
            }
        }
    }
}

