/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.identity.intents.model.UserAddress;
import com.google.android.gms.wallet.AutoResolvableResult;
import com.google.android.gms.wallet.CardInfo;
import com.google.android.gms.wallet.PaymentMethodToken;
import com.google.android.gms.wallet.zzaa;

@SafeParcelable.Class(creator="PaymentDataCreator")
public final class PaymentData
extends AbstractSafeParcelable
implements AutoResolvableResult {
    @NonNull
    public static final Parcelable.Creator<PaymentData> CREATOR = new zzaa();
    @SafeParcelable.Field(id=1)
    String zza;
    @SafeParcelable.Field(id=2)
    CardInfo zzb;
    @SafeParcelable.Field(id=3)
    UserAddress zzc;
    @SafeParcelable.Field(id=4)
    PaymentMethodToken zzd;
    @SafeParcelable.Field(id=5)
    String zze;
    @SafeParcelable.Field(id=6)
    Bundle zzf;
    @SafeParcelable.Field(id=7)
    String zzg;
    @SafeParcelable.Field(id=8)
    @Nullable
    Bundle zzh;

    @Deprecated
    @Nullable
    public Bundle getExtraData() {
        return this.zzf;
    }

    @Nullable
    public Bundle getLastSavedState() {
        return this.zzh;
    }

    @Deprecated
    @Nullable
    public UserAddress getShippingAddress() {
        return this.zzc;
    }

    @Deprecated
    @NonNull
    public CardInfo getCardInfo() {
        return this.zzb;
    }

    @NonNull
    public static PaymentData fromJson(@NonNull String paymentDataJson) {
        String string;
        new PaymentData().zzg = (String)Preconditions.checkNotNull((Object)string, (Object)"paymentDataJson cannot be null!");
        return new PaymentData();
    }

    @Nullable
    public static PaymentData getFromIntent(@NonNull Intent intent) {
        return (PaymentData)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"com.google.android.gms.wallet.PaymentData", CREATOR);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PaymentData withLastSavedState(@Nullable Bundle savedState) {
        void var1_1;
        this.zzh = var1_1;
        return this;
    }

    @Deprecated
    @Nullable
    public PaymentMethodToken getPaymentMethodToken() {
        return this.zzd;
    }

    @Deprecated
    @Nullable
    public String getEmail() {
        return this.zza;
    }

    @Deprecated
    @NonNull
    public String getGoogleTransactionId() {
        return this.zze;
    }

    @NonNull
    public String toJson() {
        return this.zzg;
    }

    private PaymentData() {
    }

    @SafeParcelable.Constructor
    PaymentData(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) CardInfo cardInfo, @SafeParcelable.Param(id=3) UserAddress userAddress, @SafeParcelable.Param(id=4) PaymentMethodToken paymentMethodToken, @SafeParcelable.Param(id=5) String string2, @SafeParcelable.Param(id=6) Bundle bundle, @SafeParcelable.Param(id=7) String string3, @SafeParcelable.Param(id=8) @Nullable Bundle bundle2) {
        this.zza = string;
        this.zzb = cardInfo;
        this.zzc = userAddress;
        this.zzd = paymentMethodToken;
        this.zze = string2;
        this.zzf = bundle;
        this.zzg = string3;
        this.zzh = bundle2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putIntoIntent(@NonNull Intent intent) {
        void var1_1;
        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)this, (Intent)var1_1, (String)"com.google.android.gms.wallet.PaymentData");
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.zzb, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.zzc, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)4, (Parcelable)this.zzd, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.zze, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)var1_1, (int)6, (Bundle)this.zzf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.zzg, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeBundle((Parcel)v1, (int)8, (Bundle)this.zzh, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }
}

