/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.button;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.button.zza;
import com.google.android.gms.wallet.button.zzb;

@SafeParcelable.Class(creator="ButtonOptionsCreator")
public final class ButtonOptions
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final Parcelable.Creator<ButtonOptions> CREATOR = new zzb();
    @SafeParcelable.Field(id=1, getter="getButtonType", defaultValueUnchecked="0")
    int zza;
    @SafeParcelable.Field(id=2, getter="getButtonTheme", defaultValueUnchecked="0")
    int zzb;
    @SafeParcelable.Field(id=3, getter="getCornerRadius", defaultValueUnchecked="0")
    int zzc;
    @SafeParcelable.Field(id=4, getter="getAllowedPaymentMethods")
    String zzd;
    boolean zze = false;

    public int getButtonTheme() {
        return this.zzb;
    }

    public int getButtonType() {
        return this.zza;
    }

    public int getCornerRadius() {
        return this.zzc;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza});
    }

    @NonNull
    public static Builder newBuilder() {
        return new ButtonOptions().new Builder(null);
    }

    @NonNull
    public String getAllowedPaymentMethods() {
        return this.zzd;
    }

    private ButtonOptions() {
    }

    @SafeParcelable.Constructor
    ButtonOptions(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) int n3, @SafeParcelable.Param(id=4) String string) {
        this.zza = (Integer)Preconditions.checkNotNull((Object)n);
        this.zzb = (Integer)Preconditions.checkNotNull((Object)n2);
        this.zzc = (Integer)Preconditions.checkNotNull((Object)n3);
        this.zzd = (String)Preconditions.checkNotNull((Object)string);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getButtonType());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getButtonTheme());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getCornerRadius());
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)4, (String)this.getAllowedPaymentMethods(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof ButtonOptions) {
            ButtonOptions buttonOptions;
            buttonOptions = buttonOptions;
            return Objects.equal((Object)this.zza, (Object)buttonOptions.zza) && Objects.equal((Object)this.zzb, (Object)buttonOptions.zzb) && Objects.equal((Object)this.zzc, (Object)buttonOptions.zzc) && Objects.equal((Object)this.zzd, (Object)buttonOptions.zzd);
        }
        return false;
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAllowedPaymentMethods(@NonNull String allowedPaymentMethods) {
            void var1_1;
            ButtonOptions.this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setButtonTheme(int buttonTheme) {
            void var1_1;
            ButtonOptions.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setButtonType(int buttonType) {
            void var1_1;
            ButtonOptions.this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCornerRadius(int cornerRadius) {
            void var1_1;
            ButtonOptions buttonOptions = ButtonOptions.this;
            buttonOptions.zzc = var1_1;
            buttonOptions.zze = true;
            return this;
        }

        @NonNull
        public ButtonOptions build() {
            return ButtonOptions.this;
        }

        /* synthetic */ Builder(zza zza2) {
        }
    }
}

