/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzal;
import com.google.android.gms.wallet.zzam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SafeParcelable.Class(creator="ShippingAddressRequirementsCreator")
public final class ShippingAddressRequirements
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ShippingAddressRequirements> CREATOR;
    @SafeParcelable.Field(id=1)
    ArrayList zza;

    @NonNull
    public static Builder newBuilder() {
        ShippingAddressRequirements shippingAddressRequirements = new ShippingAddressRequirements();
        Builder builder = shippingAddressRequirements.new Builder(null);
        return builder;
    }

    @Nullable
    public ArrayList<String> getAllowedCountryCodes() {
        return this.zza;
    }

    static {
        zzam zzam2;
        CREATOR = zzam2 = new zzam();
    }

    private ShippingAddressRequirements() {
    }

    @SafeParcelable.Constructor
    ShippingAddressRequirements(@SafeParcelable.Param(id=1) ArrayList arrayList) {
        this.zza = arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeStringList((Parcel)var1_1, (int)1, (List)this.zza, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addAllowedCountryCode(@NonNull String allowedCountryCode) {
            void var1_1;
            Preconditions.checkNotEmpty((String)allowedCountryCode, (Object)"allowedCountryCode can't be null or empty! If you don't have restrictions, just leave it unset.");
            ShippingAddressRequirements shippingAddressRequirements = ShippingAddressRequirements.this;
            if (shippingAddressRequirements.zza == null) {
                ArrayList arrayList;
                shippingAddressRequirements.zza = arrayList = new ArrayList();
            }
            ShippingAddressRequirements.this.zza.add(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addAllowedCountryCodes(@NonNull Collection<String> allowedCountryCodes) {
            void var1_1;
            if (allowedCountryCodes == null || var1_1.isEmpty()) {
                Object object = new IllegalArgumentException("allowedCountryCodes can't be null or empty! If you don't have restrictions, just leave it unset.");
                throw object;
            }
            ShippingAddressRequirements shippingAddressRequirements = ((Builder)object).ShippingAddressRequirements.this;
            if (shippingAddressRequirements.zza == null) {
                ArrayList arrayList;
                shippingAddressRequirements.zza = arrayList = new ArrayList();
            }
            ((Builder)object).ShippingAddressRequirements.this.zza.addAll(var1_1);
            return object;
        }

        @NonNull
        public ShippingAddressRequirements build() {
            return ShippingAddressRequirements.this;
        }

        /* synthetic */ Builder(zzal zzal2) {
        }
    }
}

