/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzf;
import com.google.android.gms.wallet.zzg;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="CardRequirementsCreator")
public final class CardRequirements
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<CardRequirements> CREATOR;
    @SafeParcelable.Field(id=1)
    ArrayList<Integer> zza;
    @SafeParcelable.Field(id=2, defaultValue="true")
    boolean zzb;
    @SafeParcelable.Field(id=3)
    boolean zzc;
    @SafeParcelable.Field(id=4)
    int zzd;

    public int getBillingAddressFormat() {
        return this.zzd;
    }

    @NonNull
    public static Builder newBuilder() {
        CardRequirements cardRequirements = new CardRequirements();
        Builder builder = cardRequirements.new Builder(null);
        return builder;
    }

    @Nullable
    public ArrayList<Integer> getAllowedCardNetworks() {
        return this.zza;
    }

    static {
        zzg zzg2;
        CREATOR = zzg2 = new zzg();
    }

    private CardRequirements() {
        this.zzb = true;
    }

    @SafeParcelable.Constructor
    CardRequirements(@SafeParcelable.Param(id=1) ArrayList<Integer> arrayList, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) boolean bl2, @SafeParcelable.Param(id=4) int n) {
        this.zza = arrayList;
        this.zzb = bl;
        this.zzc = bl2;
        this.zzd = n;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeIntegerList((Parcel)var1_1, (int)1, this.zza, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)2, (boolean)this.zzb);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)3, (boolean)this.zzc);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.zzd);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean allowPrepaidCards() {
        return this.zzb;
    }

    public boolean isBillingAddressRequired() {
        return this.zzc;
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addAllowedCardNetwork(int allowedCardNetwork) {
            void var1_1;
            CardRequirements cardRequirements = CardRequirements.this;
            if (cardRequirements.zza == null) {
                ArrayList arrayList = new ArrayList();
                cardRequirements.zza = arrayList;
            }
            CardRequirements.this.zza.add((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder addAllowedCardNetworks(@NonNull Collection<Integer> allowedCardNetworks) {
            void var1_1;
            boolean bl = allowedCardNetworks != null ? !var1_1.isEmpty() : false;
            Preconditions.checkArgument((boolean)bl, (Object)"allowedCardNetworks can't be null or empty! You must provide a valid value from WalletConstants.CardNetwork.");
            CardRequirements cardRequirements = CardRequirements.this;
            if (cardRequirements.zza == null) {
                ArrayList arrayList = new ArrayList();
                cardRequirements.zza = arrayList;
            }
            CardRequirements.this.zza.addAll((Collection<Integer>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAllowPrepaidCards(boolean allowPrepaidCards) {
            void var1_1;
            CardRequirements.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBillingAddressFormat(int billingAddressFormat) {
            void var1_1;
            CardRequirements.this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBillingAddressRequired(boolean billingAddressRequired) {
            void var1_1;
            CardRequirements.this.zzc = var1_1;
            return this;
        }

        @NonNull
        public CardRequirements build() {
            Preconditions.checkNotNull(CardRequirements.this.zza, (Object)"Allowed card networks must be non-empty! You can set it through addAllowedCardNetwork() or addAllowedCardNetworks() in the CardRequirements Builder.");
            return CardRequirements.this;
        }

        /* synthetic */ Builder(zzf zzf2) {
        }
    }
}

