/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzaa;
import com.google.android.gms.wallet.zzz;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PaymentMethodTokenizationParametersCreator")
public final class PaymentMethodTokenizationParameters
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<PaymentMethodTokenizationParameters> CREATOR;
    @SafeParcelable.Field(id=2)
    int zza;
    @SafeParcelable.Field(id=3)
    Bundle zzb;

    public int getPaymentMethodTokenizationType() {
        return this.zza;
    }

    @NonNull
    public Bundle getParameters() {
        Bundle bundle = new Bundle(this.zzb);
        return bundle;
    }

    @NonNull
    public static Builder newBuilder() {
        PaymentMethodTokenizationParameters paymentMethodTokenizationParameters = new PaymentMethodTokenizationParameters();
        Builder builder = paymentMethodTokenizationParameters.new Builder(null);
        return builder;
    }

    static {
        zzaa zzaa2;
        CREATOR = zzaa2 = new zzaa();
    }

    private PaymentMethodTokenizationParameters() {
        Bundle bundle;
        this.zzb = bundle = new Bundle();
    }

    @SafeParcelable.Constructor
    PaymentMethodTokenizationParameters(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) Bundle bundle) {
        new Bundle();
        this.zza = n;
        this.zzb = bundle;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.zza);
        SafeParcelWriter.writeBundle((Parcel)var1_1, (int)3, (Bundle)this.zzb, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addParameter(@NonNull String name, @NonNull String value) {
            void var1_1;
            void var2_2;
            Preconditions.checkNotEmpty((String)name, (Object)"Tokenization parameter name must not be empty");
            Preconditions.checkNotEmpty((String)var2_2, (Object)"Tokenization parameter value must not be empty");
            PaymentMethodTokenizationParameters.this.zzb.putString((String)var1_1, (String)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPaymentMethodTokenizationType(int tokenizationType) {
            void var1_1;
            PaymentMethodTokenizationParameters.this.zza = var1_1;
            return this;
        }

        @NonNull
        public PaymentMethodTokenizationParameters build() {
            return PaymentMethodTokenizationParameters.this;
        }

        /* synthetic */ Builder(zzz zzz2) {
        }
    }
}

