/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.wallet.zzab;
import com.google.android.gms.internal.wallet.zzac;
import com.google.android.gms.internal.wallet.zzae;
import com.google.android.gms.internal.wallet.zzv;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.WalletObjectsClient;
import com.google.android.gms.wallet.wobs.WalletObjects;
import com.google.android.gms.wallet.zzaj;
import java.util.Locale;

public final class Wallet {
    @RecentlyNonNull
    public static final Api<WalletOptions> API;
    private static final Api.ClientKey<zzab> zzd;
    private static final Api.AbstractClientBuilder<zzab, WalletOptions> zze;
    @RecentlyNonNull
    public static final WalletObjects zza;
    @Deprecated
    public static final zzv zzb;
    @ShowFirstParty
    public static final zzac zzc;

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static PaymentsClient getPaymentsClient(@RecentlyNonNull Activity activity, @RecentlyNonNull WalletOptions options) {
        void var1_1;
        Activity activity2;
        PaymentsClient paymentsClient = new PaymentsClient(activity2, (WalletOptions)var1_1);
        return paymentsClient;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static PaymentsClient getPaymentsClient(@RecentlyNonNull Context context, @RecentlyNonNull WalletOptions options) {
        void var1_1;
        Context context2;
        PaymentsClient paymentsClient = new PaymentsClient(context2, (WalletOptions)var1_1);
        return paymentsClient;
    }

    /*
     * WARNING - void declaration
     */
    @RecentlyNonNull
    public static WalletObjectsClient getWalletObjectsClient(@RecentlyNonNull Activity activity, @Nullable WalletOptions options) {
        void var1_1;
        Activity activity2;
        WalletObjectsClient walletObjectsClient = new WalletObjectsClient(activity2, (WalletOptions)var1_1);
        return walletObjectsClient;
    }

    static {
        Object object;
        zzd = object = new Api.ClientKey();
        zze = object = new zzaj();
        API = object = new Api("Wallet.API", zze, zzd);
        object = new zzv();
        zzb = object;
        object = new zzae();
        zza = object;
        object = new zzac();
        zzc = object;
    }

    private Wallet() {
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasAccountOptions {
        public final int environment;
        public final int theme;
        @ShowFirstParty
        @RecentlyNonNull
        public final Account zza;
        @VisibleForTesting
        final boolean zzb;

        public int hashCode() {
            Object[] objectArray = new Object[]{this.environment, this.theme, null, this.zzb};
            return Objects.hashCode((Object[])objectArray);
        }

        @RecentlyNonNull
        public Account getAccount() {
            return null;
        }

        private WalletOptions() {
            Builder builder = new Builder();
            this(builder);
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zza;
            this.theme = builder.zzb;
            this.zzb = builder.zzc;
            this.zza = null;
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof WalletOptions) {
                WalletOptions walletOptions;
                walletOptions = walletOptions;
                if (Objects.equal((Object)this.environment, (Object)walletOptions.environment) && Objects.equal((Object)this.theme, (Object)walletOptions.theme)) {
                    Account cfr_ignored_0 = walletOptions.zza;
                    if (Objects.equal(null, null) && Objects.equal((Object)this.zzb, (Object)walletOptions.zzb)) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        /* synthetic */ WalletOptions(zzaj object) {
            this((Builder)object);
        }

        /* synthetic */ WalletOptions(Builder builder, zzaj zzaj2) {
            this(builder);
        }

        public static final class Builder {
            private int zza = 3;
            private int zzb = 1;
            private boolean zzc = true;

            /*
             * Enabled aggressive block sorting
             */
            @RecentlyNonNull
            public Builder setEnvironment(int environment) {
                int n;
                if (environment != 0) {
                    if (n != 0) {
                        if (n != 2 && n != 1 && n != 23 && n != 3) {
                            Object object = Locale.US;
                            Object[] objectArray = new Object[]{n};
                            object = String.format((Locale)object, "Invalid environment value %d", objectArray);
                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException((String)object);
                            throw illegalArgumentException;
                        }
                    } else {
                        n = 0;
                    }
                }
                ((Builder)object).zza = n;
                return object;
            }

            /*
             * WARNING - void declaration
             */
            @RecentlyNonNull
            public Builder setTheme(int theme) {
                void var1_1;
                if (theme != 0 && var1_1 != true && var1_1 != 2 && var1_1 != 3) {
                    Object object = Locale.US;
                    Object[] objectArray = new Object[]{(int)var1_1};
                    object = String.format((Locale)object, "Invalid theme value %d", objectArray);
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException((String)object);
                    throw illegalArgumentException;
                }
                ((Builder)object).zzb = var1_1;
                return object;
            }

            @Deprecated
            @RecentlyNonNull
            public Builder useGoogleWallet() {
                this.zzc = false;
                return this;
            }

            @RecentlyNonNull
            public WalletOptions build() {
                WalletOptions walletOptions = new WalletOptions(this, null);
                return walletOptions;
            }
        }
    }
}

