/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzaf;
import com.google.android.gms.wallet.zzag;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="ShippingAddressRequirementsCreator")
public final class ShippingAddressRequirements
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<ShippingAddressRequirements> CREATOR;
    @SafeParcelable.Field(id=1)
    ArrayList<String> zza;

    @RecentlyNonNull
    public static Builder newBuilder() {
        ShippingAddressRequirements shippingAddressRequirements = new ShippingAddressRequirements();
        Builder builder = shippingAddressRequirements.new Builder(null);
        return builder;
    }

    @RecentlyNullable
    public ArrayList<String> getAllowedCountryCodes() {
        return this.zza;
    }

    static {
        zzag zzag2;
        CREATOR = zzag2 = new zzag();
    }

    private ShippingAddressRequirements() {
    }

    @SafeParcelable.Constructor
    ShippingAddressRequirements(@SafeParcelable.Param(id=1) ArrayList<String> arrayList) {
        this.zza = arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeStringList((Parcel)var1_1, (int)1, this.zza, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public final class Builder {
        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addAllowedCountryCode(@RecentlyNonNull String allowedCountryCode) {
            void var1_1;
            Preconditions.checkNotEmpty((String)allowedCountryCode, (Object)"allowedCountryCode can't be null or empty! If you don't have restrictions, just leave it unset.");
            ShippingAddressRequirements shippingAddressRequirements = ShippingAddressRequirements.this;
            if (shippingAddressRequirements.zza == null) {
                ArrayList arrayList = new ArrayList();
                shippingAddressRequirements.zza = arrayList;
            }
            ShippingAddressRequirements.this.zza.add((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addAllowedCountryCodes(@RecentlyNonNull Collection<String> allowedCountryCodes) {
            void var1_1;
            if (allowedCountryCodes == null || var1_1.isEmpty()) {
                Object object = new IllegalArgumentException("allowedCountryCodes can't be null or empty! If you don't have restrictions, just leave it unset.");
                throw object;
            }
            ShippingAddressRequirements shippingAddressRequirements = ((Builder)object).ShippingAddressRequirements.this;
            if (shippingAddressRequirements.zza == null) {
                ArrayList arrayList = new ArrayList();
                shippingAddressRequirements.zza = arrayList;
            }
            ((Builder)object).ShippingAddressRequirements.this.zza.addAll((Collection<String>)var1_1);
            return object;
        }

        @RecentlyNonNull
        public ShippingAddressRequirements build() {
            return ShippingAddressRequirements.this;
        }

        /* synthetic */ Builder(zzaf zzaf2) {
        }
    }
}

