/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.CommonWalletObject;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.wobs.zzb;
import com.google.android.gms.wallet.zzl;
import com.google.android.gms.wallet.zzm;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GiftCardWalletObjectCreator")
public final class GiftCardWalletObject
extends AbstractSafeParcelable {
    @RecentlyNonNull
    public static final Parcelable.Creator<GiftCardWalletObject> CREATOR;
    @SafeParcelable.Field(id=2)
    CommonWalletObject zza;
    @SafeParcelable.Field(id=3)
    String zzb;
    @SafeParcelable.Field(id=4)
    String zzc;
    @Deprecated
    @SafeParcelable.Field(id=5)
    String zzd;
    @SafeParcelable.Field(id=6)
    long zze;
    @SafeParcelable.Field(id=7)
    String zzf;
    @SafeParcelable.Field(id=8)
    long zzg;
    @SafeParcelable.Field(id=9)
    String zzh;

    public int getState() {
        return this.zza.zza();
    }

    public long getBalanceMicros() {
        return this.zze;
    }

    public long getBalanceUpdateTime() {
        return this.zzg;
    }

    @RecentlyNonNull
    public static Builder newBuilder() {
        GiftCardWalletObject giftCardWalletObject = new GiftCardWalletObject();
        Builder builder = giftCardWalletObject.new Builder(null);
        return builder;
    }

    @RecentlyNonNull
    public TimeInterval getValidTimeInterval() {
        return this.zza.zzc();
    }

    @RecentlyNonNull
    public String getBalanceCurrencyCode() {
        return this.zzf;
    }

    @RecentlyNonNull
    public String getBarcodeAlternateText() {
        return this.zza.zzd();
    }

    @Deprecated
    @RecentlyNonNull
    public String getBarcodeLabel() {
        return this.zza.zze();
    }

    @RecentlyNonNull
    public String getBarcodeType() {
        return this.zza.zzf();
    }

    @RecentlyNonNull
    public String getBarcodeValue() {
        return this.zza.zzg();
    }

    @Deprecated
    @RecentlyNonNull
    public String getCardIdentifier() {
        return this.zzd;
    }

    @RecentlyNonNull
    public String getCardNumber() {
        return this.zzb;
    }

    @RecentlyNonNull
    public String getClassId() {
        return this.zza.zzh();
    }

    @RecentlyNonNull
    public String getEventNumber() {
        return this.zzh;
    }

    @RecentlyNonNull
    public String getId() {
        return this.zza.zzi();
    }

    @Deprecated
    @RecentlyNonNull
    public String getInfoModuleDataHexBackgroundColor() {
        return this.zza.zzj();
    }

    @Deprecated
    @RecentlyNonNull
    public String getInfoModuleDataHexFontColor() {
        return this.zza.zzk();
    }

    @RecentlyNonNull
    public String getIssuerName() {
        return this.zza.zzl();
    }

    @RecentlyNonNull
    public String getPin() {
        return this.zzc;
    }

    @RecentlyNonNull
    public String getTitle() {
        return this.zza.zzm();
    }

    @RecentlyNonNull
    public ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zza.zzn();
    }

    @RecentlyNonNull
    public ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zza.zzo();
    }

    @RecentlyNonNull
    public ArrayList<UriData> getLinksModuleDataUris() {
        return this.zza.zzp();
    }

    @RecentlyNonNull
    public ArrayList<LatLng> getLocations() {
        return this.zza.zzq();
    }

    @RecentlyNonNull
    public ArrayList<WalletObjectMessage> getMessages() {
        return this.zza.zzr();
    }

    @RecentlyNonNull
    public ArrayList<TextModuleData> getTextModulesData() {
        return this.zza.zzs();
    }

    static {
        zzm zzm2;
        CREATOR = zzm2 = new zzm();
    }

    GiftCardWalletObject() {
        this.zza = CommonWalletObject.zzb().zzz();
    }

    @SafeParcelable.Constructor
    GiftCardWalletObject(@SafeParcelable.Param(id=2) CommonWalletObject commonWalletObject, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) long l, @SafeParcelable.Param(id=7) String string4, @SafeParcelable.Param(id=8) long l2, @SafeParcelable.Param(id=9) String string5) {
        CommonWalletObject.zzb();
        this.zza = commonWalletObject;
        this.zzb = string;
        this.zzc = string2;
        this.zze = l;
        this.zzf = string4;
        this.zzg = l2;
        this.zzh = string5;
        this.zzd = string3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@RecentlyNonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.zza, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.zzd, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)6, (long)this.zze);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.zzf, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)8, (long)this.zzg);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)9, (String)this.zzh, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zza.zzt();
    }

    public final class Builder {
        private zzb zzb = CommonWalletObject.zzb();

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addImageModuleDataMainImageUri(@RecentlyNonNull UriData uri) {
            void var1_1;
            this.zzb.zza((UriData)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addImageModuleDataMainImageUris(@RecentlyNonNull Collection<UriData> uris) {
            void var1_1;
            this.zzb.zzb((Collection<UriData>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addInfoModuleDataLabelValueRow(@RecentlyNonNull LabelValueRow row) {
            void var1_1;
            this.zzb.zzc((LabelValueRow)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addInfoModuleDataLabelValueRows(@RecentlyNonNull Collection<LabelValueRow> rows) {
            void var1_1;
            this.zzb.zzd((Collection<LabelValueRow>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addLinksModuleDataUri(@RecentlyNonNull UriData uri) {
            void var1_1;
            this.zzb.zze((UriData)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addLinksModuleDataUris(@RecentlyNonNull Collection<UriData> uris) {
            void var1_1;
            this.zzb.zzf((Collection<UriData>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addLocation(@RecentlyNonNull LatLng location) {
            void var1_1;
            this.zzb.zzg((LatLng)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addLocations(@RecentlyNonNull Collection<LatLng> locations) {
            void var1_1;
            this.zzb.zzh((Collection<LatLng>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addMessage(@RecentlyNonNull WalletObjectMessage message) {
            void var1_1;
            this.zzb.zzi((WalletObjectMessage)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addMessages(@RecentlyNonNull Collection<WalletObjectMessage> messages) {
            void var1_1;
            this.zzb.zzj((Collection<WalletObjectMessage>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addTextModuleData(@RecentlyNonNull TextModuleData data) {
            void var1_1;
            this.zzb.zzk((TextModuleData)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder addTextModulesData(@RecentlyNonNull Collection<TextModuleData> data) {
            void var1_1;
            this.zzb.zzl((Collection<TextModuleData>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setBalanceCurrencyCode(@RecentlyNonNull String currencyCode) {
            void var1_1;
            GiftCardWalletObject.this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setBalanceMicros(long valueMicros) {
            void var1_1;
            GiftCardWalletObject.this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setBalanceUpdateTime(long balanceUpdateTimeStamp) {
            void var1_1;
            GiftCardWalletObject.this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setBarcodeAlternateText(@RecentlyNonNull String barcodeAlternateText) {
            void var1_1;
            this.zzb.zzm((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @RecentlyNonNull
        public Builder setBarcodeLabel(@RecentlyNonNull String barcodeLabel) {
            void var1_1;
            this.zzb.zzn((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setBarcodeType(@RecentlyNonNull String barcodeType) {
            void var1_1;
            this.zzb.zzo((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setBarcodeValue(@RecentlyNonNull String barcodeValue) {
            void var1_1;
            this.zzb.zzp((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @RecentlyNonNull
        public Builder setCardIdentifier(@RecentlyNonNull String cardIdentifier) {
            void var1_1;
            GiftCardWalletObject.this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setCardNumber(@RecentlyNonNull String cardNumber) {
            void var1_1;
            GiftCardWalletObject.this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setClassId(@RecentlyNonNull String classId) {
            void var1_1;
            this.zzb.zzq((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setEventNumber(@RecentlyNonNull String eventNumber) {
            void var1_1;
            GiftCardWalletObject.this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setId(@RecentlyNonNull String id) {
            void var1_1;
            this.zzb.zzr((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @RecentlyNonNull
        public Builder setInfoModuleDataHexBackgroundColor(@RecentlyNonNull String color) {
            void var1_1;
            this.zzb.zzs((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @RecentlyNonNull
        public Builder setInfoModuleDataHexFontColor(@RecentlyNonNull String color) {
            void var1_1;
            this.zzb.zzt((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setInfoModuleDataShowLastUpdateTime(boolean show) {
            void var1_1;
            this.zzb.zzu((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setIssuerName(@RecentlyNonNull String issuerName) {
            void var1_1;
            this.zzb.zzv((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setPin(@RecentlyNonNull String pin) {
            void var1_1;
            GiftCardWalletObject.this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setState(int state) {
            void var1_1;
            this.zzb.zzx((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setTitle(@RecentlyNonNull String title) {
            void var1_1;
            this.zzb.zzw((String)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @RecentlyNonNull
        public Builder setValidTimeInterval(@RecentlyNonNull TimeInterval interval) {
            void var1_1;
            this.zzb.zzy((TimeInterval)var1_1);
            return this;
        }

        @RecentlyNonNull
        public GiftCardWalletObject build() {
            Preconditions.checkArgument((boolean)(TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zzb) ^ true), (Object)"Card number is required.");
            GiftCardWalletObject.this.zza = this.zzb.zzz();
            Preconditions.checkArgument((boolean)(TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zza.zzm()) ^ true), (Object)"Card name is required.");
            Preconditions.checkArgument((boolean)(TextUtils.isEmpty((CharSequence)GiftCardWalletObject.this.zza.zzl()) ^ true), (Object)"Card issuer name is required.");
            return GiftCardWalletObject.this;
        }

        /* synthetic */ Builder(zzl zzl2) {
        }
    }
}

