/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzah;
import com.google.android.gms.wallet.zzai;

@SafeParcelable.Class(creator="TransactionInfoCreator")
public final class TransactionInfo
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<TransactionInfo> CREATOR = new zzai();
    @SafeParcelable.Field(id=1)
    int zzdz;
    @SafeParcelable.Field(id=2)
    String zzea;
    @SafeParcelable.Field(id=3)
    String zzeb;

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TransactionInfo transactionInfo = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)transactionInfo.zzdz);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)transactionInfo.zzea, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)transactionInfo.zzeb, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Constructor
    public TransactionInfo(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2) {
        this.zzdz = n;
        this.zzea = string;
        this.zzeb = string2;
    }

    private TransactionInfo() {
    }

    public static Builder newBuilder() {
        return new TransactionInfo().new Builder(null);
    }

    public final int getTotalPriceStatus() {
        return this.zzdz;
    }

    @Nullable
    public final String getTotalPrice() {
        return this.zzea;
    }

    public final String getCurrencyCode() {
        return this.zzeb;
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder setTotalPriceStatus(int n) {
            TransactionInfo.this.zzdz = n;
            return this;
        }

        public final Builder setTotalPrice(@NonNull String string) {
            TransactionInfo.this.zzea = string;
            return this;
        }

        public final Builder setCurrencyCode(@NonNull String string) {
            TransactionInfo.this.zzeb = string;
            return this;
        }

        public final TransactionInfo build() {
            Preconditions.checkNotEmpty((String)TransactionInfo.this.zzeb, (Object)"currencyCode must be set!");
            Builder builder = this;
            if (!(builder.TransactionInfo.this.zzdz == 1 || builder.TransactionInfo.this.zzdz == 2 || builder.TransactionInfo.this.zzdz == 3)) {
                throw new IllegalArgumentException("totalPriceStatus must be set to one of WalletConstants.TotalPriceStatus!");
            }
            if (TransactionInfo.this.zzdz == 2) {
                Preconditions.checkNotEmpty((String)TransactionInfo.this.zzea, (Object)"An estimated total price must be set if totalPriceStatus is set to WalletConstants.TOTAL_PRICE_STATUS_ESTIMATED!");
            }
            if (TransactionInfo.this.zzdz == 3) {
                Preconditions.checkNotEmpty((String)TransactionInfo.this.zzea, (Object)"An final total price must be set if totalPriceStatus is set to WalletConstants.TOTAL_PRICE_STATUS_FINAL!");
            }
            return TransactionInfo.this;
        }

        /* synthetic */ Builder(zzah zzah2) {
            this();
        }
    }
}

