/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.wallet;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.internal.wallet.zzaa;
import com.google.android.gms.internal.wallet.zzp;
import com.google.android.gms.internal.wallet.zzq;
import com.google.android.gms.internal.wallet.zzs;
import com.google.android.gms.internal.wallet.zzv;
import com.google.android.gms.internal.wallet.zzw;
import com.google.android.gms.internal.wallet.zzx;
import com.google.android.gms.internal.wallet.zzy;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.wallet.AutoResolvableVoidResult;
import com.google.android.gms.wallet.CreateWalletObjectsRequest;
import com.google.android.gms.wallet.IsReadyToPayRequest;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.zzh;

public final class zzt
extends GmsClient<zzq> {
    private final Context zzfg;
    private final int environment;
    private final String zzcd;
    private final int theme;
    private final boolean zzeh;

    public zzt(Context context, Looper looper, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, int n, int n2, boolean bl) {
        super(context, looper, 4, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zzfg = context;
        this.environment = n;
        this.zzcd = clientSettings.getAccountName();
        this.theme = n2;
        this.zzeh = bl;
    }

    public final boolean requiresAccount() {
        return true;
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.wallet.service.BIND";
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.wallet.internal.IOwService";
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, int n) {
        zzw zzw2 = new zzw((Activity)this.zzfg, n);
        Bundle bundle = this.zze();
        try {
            ((zzq)this.getService()).zza(createWalletObjectsRequest, bundle, (zzs)zzw2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzv)zzw2).zza(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(CreateWalletObjectsRequest createWalletObjectsRequest, TaskCompletionSource<AutoResolvableVoidResult> taskCompletionSource) {
        Bundle bundle = this.zze();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzx zzx2 = new zzx(taskCompletionSource);
        try {
            ((zzq)this.getService()).zza(createWalletObjectsRequest, bundle, (zzs)zzx2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException creating wallet objects", (Throwable)remoteException);
            ((zzv)zzx2).zza(8, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(IsReadyToPayRequest isReadyToPayRequest, TaskCompletionSource<Boolean> taskCompletionSource) throws RemoteException {
        zzy zzy2 = new zzy(taskCompletionSource);
        try {
            ((zzq)this.getService()).zza(isReadyToPayRequest, this.zze(), (zzs)zzy2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException during isReadyToPay", (Throwable)remoteException);
            ((zzv)zzy2).zza(Status.RESULT_INTERNAL_ERROR, false, Bundle.EMPTY);
            return;
        }
    }

    public final void zza(PaymentDataRequest paymentDataRequest, TaskCompletionSource<PaymentData> taskCompletionSource) {
        Bundle bundle = this.zze();
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_AUTO_RESOLVABLE_RESULT", true);
        zzaa zzaa2 = new zzaa(taskCompletionSource);
        try {
            ((zzq)this.getService()).zza(paymentDataRequest, bundle, (zzs)zzaa2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e((String)"WalletClientImpl", (String)"RemoteException getting payment data", (Throwable)remoteException);
            ((zzv)zzaa2).zza(Status.RESULT_INTERNAL_ERROR, (PaymentData)null, Bundle.EMPTY);
            return;
        }
    }

    private final Bundle zze() {
        boolean bl = this.zzeh;
        int n = this.theme;
        String string = this.zzcd;
        String string2 = this.zzfg.getPackageName();
        int n2 = this.environment;
        Bundle bundle = new Bundle();
        bundle.putInt("com.google.android.gms.wallet.EXTRA_ENVIRONMENT", n2);
        bundle.putBoolean("com.google.android.gms.wallet.EXTRA_USING_ANDROID_PAY_BRAND", bl);
        bundle.putString("androidPackageName", string2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putParcelable("com.google.android.gms.wallet.EXTRA_BUYER_ACCOUNT", (Parcelable)new Account(string, "com.google"));
        }
        bundle.putInt("com.google.android.gms.wallet.EXTRA_THEME", n);
        return bundle;
    }

    public final int getMinApkVersion() {
        return 12600000;
    }

    public final Feature[] getApiFeatures() {
        return zzh.zzbh;
    }

    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wallet.internal.IOwService");
        if (iInterface instanceof zzq) {
            return (zzq)iInterface;
        }
        return new zzp(iBinder2);
    }
}

