/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.zzaf;
import com.google.android.gms.wallet.zzag;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="ShippingAddressRequirementsCreator")
public final class ShippingAddressRequirements
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<ShippingAddressRequirements> CREATOR = new zzag();
    @SafeParcelable.Field(id=1)
    ArrayList<String> zzdv;

    @SafeParcelable.Constructor
    ShippingAddressRequirements(@SafeParcelable.Param(id=1) ArrayList<String> arrayList) {
        this.zzdv = arrayList;
    }

    private ShippingAddressRequirements() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ShippingAddressRequirements shippingAddressRequirements = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)1, shippingAddressRequirements.zzdv, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final ArrayList<String> getAllowedCountryCodes() {
        return this.zzdv;
    }

    public static Builder newBuilder() {
        return new ShippingAddressRequirements().new Builder(null);
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder addAllowedCountryCode(@NonNull String string) {
            Preconditions.checkNotEmpty((String)string, (Object)"allowedCountryCode can't be null or empty! If you don't have restrictions, just leave it unset.");
            if (ShippingAddressRequirements.this.zzdv == null) {
                ShippingAddressRequirements.this.zzdv = new ArrayList();
            }
            ShippingAddressRequirements.this.zzdv.add(string);
            return this;
        }

        public final Builder addAllowedCountryCodes(@NonNull Collection<String> collection) {
            if (collection == null || collection.isEmpty()) {
                throw new IllegalArgumentException("allowedCountryCodes can't be null or empty! If you don't have restrictions, just leave it unset.");
            }
            if (ShippingAddressRequirements.this.zzdv == null) {
                ShippingAddressRequirements.this.zzdv = new ArrayList();
            }
            ShippingAddressRequirements.this.zzdv.addAll(collection);
            return this;
        }

        public final ShippingAddressRequirements build() {
            return ShippingAddressRequirements.this;
        }

        /* synthetic */ Builder(zzaf zzaf2) {
            this();
        }
    }
}

