/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wallet.CardRequirements;
import com.google.android.gms.wallet.PaymentMethodTokenizationParameters;
import com.google.android.gms.wallet.ShippingAddressRequirements;
import com.google.android.gms.wallet.TransactionInfo;
import com.google.android.gms.wallet.zzv;
import com.google.android.gms.wallet.zzw;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="PaymentDataRequestCreator")
public final class PaymentDataRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<PaymentDataRequest> CREATOR = new zzw();
    @SafeParcelable.Field(id=1)
    boolean zzdc;
    @SafeParcelable.Field(id=2)
    boolean zzdd;
    @SafeParcelable.Field(id=3)
    CardRequirements zzde;
    @SafeParcelable.Field(id=4)
    boolean zzdf;
    @SafeParcelable.Field(id=5)
    ShippingAddressRequirements zzdg;
    @SafeParcelable.Field(id=6)
    ArrayList<Integer> zzbu;
    @SafeParcelable.Field(id=7)
    PaymentMethodTokenizationParameters zzdh;
    @SafeParcelable.Field(id=8)
    TransactionInfo zzdi;
    @SafeParcelable.Field(id=9, defaultValue="true")
    boolean zzdj;
    @SafeParcelable.Field(id=10)
    String zzbw;

    @SafeParcelable.Constructor
    PaymentDataRequest(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) boolean bl2, @SafeParcelable.Param(id=3) CardRequirements cardRequirements, @SafeParcelable.Param(id=4) boolean bl3, @SafeParcelable.Param(id=5) ShippingAddressRequirements shippingAddressRequirements, @SafeParcelable.Param(id=6) ArrayList<Integer> arrayList, @SafeParcelable.Param(id=7) PaymentMethodTokenizationParameters paymentMethodTokenizationParameters, @SafeParcelable.Param(id=8) TransactionInfo transactionInfo, @SafeParcelable.Param(id=9) boolean bl4, @SafeParcelable.Param(id=10) String string) {
        this.zzdc = bl;
        this.zzdd = bl2;
        this.zzde = cardRequirements;
        this.zzdf = bl3;
        this.zzdg = shippingAddressRequirements;
        this.zzbu = arrayList;
        this.zzdh = paymentMethodTokenizationParameters;
        this.zzdi = transactionInfo;
        this.zzdj = bl4;
        this.zzbw = string;
    }

    private PaymentDataRequest() {
        this.zzdj = true;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PaymentDataRequest paymentDataRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)paymentDataRequest.zzdc);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)paymentDataRequest.zzdd);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)paymentDataRequest.zzde, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)paymentDataRequest.zzdf);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)5, (Parcelable)paymentDataRequest.zzdg, (int)n, (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)6, paymentDataRequest.zzbu, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)7, (Parcelable)paymentDataRequest.zzdh, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)8, (Parcelable)paymentDataRequest.zzdi, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)paymentDataRequest.zzdj);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)paymentDataRequest.zzbw, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @Deprecated
    public final boolean isEmailRequired() {
        return this.zzdc;
    }

    @Deprecated
    public final boolean isPhoneNumberRequired() {
        return this.zzdd;
    }

    @Deprecated
    @Nullable
    public final CardRequirements getCardRequirements() {
        return this.zzde;
    }

    @Deprecated
    public final boolean isShippingAddressRequired() {
        return this.zzdf;
    }

    @Deprecated
    @Nullable
    public final ShippingAddressRequirements getShippingAddressRequirements() {
        return this.zzdg;
    }

    @Deprecated
    public final ArrayList<Integer> getAllowedPaymentMethods() {
        return this.zzbu;
    }

    @Deprecated
    public final PaymentMethodTokenizationParameters getPaymentMethodTokenizationParameters() {
        return this.zzdh;
    }

    @Deprecated
    public final TransactionInfo getTransactionInfo() {
        return this.zzdi;
    }

    @Deprecated
    public final boolean isUiRequired() {
        return this.zzdj;
    }

    @Deprecated
    public static Builder newBuilder() {
        return new PaymentDataRequest().new Builder(null);
    }

    public static PaymentDataRequest fromJson(String string) {
        String string2 = (String)Preconditions.checkNotNull((Object)string, (Object)"paymentDataRequestJson cannot be null!");
        Builder builder = PaymentDataRequest.newBuilder();
        PaymentDataRequest.newBuilder().PaymentDataRequest.this.zzbw = string2;
        return builder.build();
    }

    public final String toJson() {
        return this.zzbw;
    }

    @Deprecated
    public final class Builder {
        private Builder() {
        }

        public final Builder setEmailRequired(boolean bl) {
            PaymentDataRequest.this.zzdc = bl;
            return this;
        }

        public final Builder setPhoneNumberRequired(boolean bl) {
            PaymentDataRequest.this.zzdd = bl;
            return this;
        }

        public final Builder setCardRequirements(@NonNull CardRequirements cardRequirements) {
            PaymentDataRequest.this.zzde = cardRequirements;
            return this;
        }

        public final Builder setShippingAddressRequired(boolean bl) {
            PaymentDataRequest.this.zzdf = bl;
            return this;
        }

        public final Builder setShippingAddressRequirements(@NonNull ShippingAddressRequirements shippingAddressRequirements) {
            PaymentDataRequest.this.zzdg = shippingAddressRequirements;
            return this;
        }

        public final Builder addAllowedPaymentMethod(int n) {
            if (PaymentDataRequest.this.zzbu == null) {
                PaymentDataRequest.this.zzbu = new ArrayList();
            }
            PaymentDataRequest.this.zzbu.add(n);
            return this;
        }

        public final Builder addAllowedPaymentMethods(@NonNull Collection<Integer> collection) {
            Preconditions.checkArgument((collection != null && !collection.isEmpty() ? 1 : 0) != 0, (Object)"allowedPaymentMethods can't be null or empty!");
            if (PaymentDataRequest.this.zzbu == null) {
                PaymentDataRequest.this.zzbu = new ArrayList();
            }
            PaymentDataRequest.this.zzbu.addAll(collection);
            return this;
        }

        public final Builder setPaymentMethodTokenizationParameters(PaymentMethodTokenizationParameters paymentMethodTokenizationParameters) {
            PaymentDataRequest.this.zzdh = paymentMethodTokenizationParameters;
            return this;
        }

        public final Builder setTransactionInfo(@NonNull TransactionInfo transactionInfo) {
            PaymentDataRequest.this.zzdi = transactionInfo;
            return this;
        }

        public final Builder setUiRequired(boolean bl) {
            PaymentDataRequest.this.zzdj = bl;
            return this;
        }

        public final PaymentDataRequest build() {
            if (PaymentDataRequest.this.zzbw == null) {
                Preconditions.checkNotNull(PaymentDataRequest.this.zzbu, (Object)"Allowed payment methods must be set! You can set it through addAllowedPaymentMethod() or addAllowedPaymentMethods() in the PaymentDataRequest Builder.");
                Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzde), (Object)"Card requirements must be set!");
                if (PaymentDataRequest.this.zzdh != null) {
                    Preconditions.checkNotNull((Object)((Object)PaymentDataRequest.this.zzdi), (Object)"Transaction info must be set if paymentMethodTokenizationParameters is set!");
                }
            }
            return PaymentDataRequest.this;
        }

        /* synthetic */ Builder(zzv zzv2) {
            this();
        }
    }
}

