/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.CommonWalletObject;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.zzr;
import com.google.android.gms.wallet.zzs;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Class(creator="OfferWalletObjectCreator")
public final class OfferWalletObject
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<OfferWalletObject> CREATOR = new zzs();
    @SafeParcelable.VersionField(id=1, getter="getVersionCode")
    private final int versionCode;
    @SafeParcelable.Field(id=2)
    String zzby;
    @SafeParcelable.Field(id=3)
    String zzcw;
    @SafeParcelable.Field(id=4)
    CommonWalletObject zzbh;

    public static Builder newBuilder() {
        return new OfferWalletObject().new Builder(null);
    }

    public final int getVersionCode() {
        return this.versionCode;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        OfferWalletObject offerWalletObject = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)offerWalletObject.getVersionCode());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)offerWalletObject.zzby, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)offerWalletObject.zzcw, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)offerWalletObject.zzbh, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Constructor
    OfferWalletObject(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) CommonWalletObject commonWalletObject) {
        this.versionCode = n;
        this.zzcw = string2;
        if (n < 3) {
            this.zzbh = CommonWalletObject.zze().zza(string).zzf();
            return;
        }
        this.zzbh = commonWalletObject;
    }

    OfferWalletObject() {
        this.versionCode = 3;
    }

    public final String getId() {
        return this.zzbh.getId();
    }

    public final String getRedemptionCode() {
        return this.zzcw;
    }

    public final String getClassId() {
        return this.zzbh.getClassId();
    }

    public final String getTitle() {
        return this.zzbh.getName();
    }

    public final String getIssuerName() {
        return this.zzbh.getIssuerName();
    }

    public final String getBarcodeAlternateText() {
        return this.zzbh.getBarcodeAlternateText();
    }

    public final String getBarcodeType() {
        return this.zzbh.getBarcodeType();
    }

    public final String getBarcodeValue() {
        return this.zzbh.getBarcodeValue();
    }

    @Deprecated
    public final String getBarcodeLabel() {
        return this.zzbh.getBarcodeLabel();
    }

    public final int getState() {
        return this.zzbh.getState();
    }

    public final ArrayList<WalletObjectMessage> getMessages() {
        return this.zzbh.getMessages();
    }

    public final TimeInterval getValidTimeInterval() {
        return this.zzbh.getValidTimeInterval();
    }

    public final ArrayList<LatLng> getLocations() {
        return this.zzbh.getLocations();
    }

    @Deprecated
    public final String getInfoModuleDataHexFontColor() {
        return this.zzbh.getInfoModuleDataHexFontColor();
    }

    @Deprecated
    public final String getInfoModuleDataHexBackgroundColor() {
        return this.zzbh.getInfoModuleDataHexBackgroundColor();
    }

    public final ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zzbh.getInfoModuleDataLabelValueRows();
    }

    public final boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zzbh.getInfoModuleDataShowLastUpdateTime();
    }

    public final ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zzbh.getImageModuleDataMainImageUris();
    }

    public final ArrayList<TextModuleData> getTextModulesData() {
        return this.zzbh.getTextModulesData();
    }

    public final ArrayList<UriData> getLinksModuleDataUris() {
        return this.zzbh.getLinksModuleDataUris();
    }

    public final class Builder {
        private CommonWalletObject.zza zzbo = CommonWalletObject.zze();

        private Builder() {
        }

        public final Builder setId(String string) {
            this.zzbo.zza(string);
            OfferWalletObject.this.zzby = string;
            return this;
        }

        public final Builder setRedemptionCode(String string) {
            OfferWalletObject.this.zzcw = string;
            return this;
        }

        public final Builder setIssuerName(String string) {
            this.zzbo.zzd(string);
            return this;
        }

        public final Builder setTitle(String string) {
            this.zzbo.zzc(string);
            return this;
        }

        public final Builder setBarcodeAlternateText(String string) {
            this.zzbo.zze(string);
            return this;
        }

        public final Builder setBarcodeType(String string) {
            this.zzbo.zzf(string);
            return this;
        }

        public final Builder setBarcodeValue(String string) {
            this.zzbo.zzg(string);
            return this;
        }

        @Deprecated
        public final Builder setBarcodeLabel(String string) {
            this.zzbo.zzh(string);
            return this;
        }

        public final Builder setClassId(String string) {
            this.zzbo.zzb(string);
            return this;
        }

        public final Builder setState(int n) {
            this.zzbo.zza(n);
            return this;
        }

        public final Builder addMessages(Collection<WalletObjectMessage> collection) {
            this.zzbo.zza(collection);
            return this;
        }

        public final Builder addMessage(WalletObjectMessage walletObjectMessage) {
            this.zzbo.zza(walletObjectMessage);
            return this;
        }

        public final Builder setValidTimeInterval(TimeInterval timeInterval) {
            this.zzbo.zza(timeInterval);
            return this;
        }

        public final Builder addLocations(Collection<LatLng> collection) {
            this.zzbo.zzb(collection);
            return this;
        }

        public final Builder addLocation(LatLng latLng) {
            this.zzbo.zza(latLng);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexFontColor(String string) {
            this.zzbo.zzi(string);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexBackgroundColor(String string) {
            this.zzbo.zzj(string);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRows(Collection<LabelValueRow> collection) {
            this.zzbo.zzc(collection);
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRow(LabelValueRow labelValueRow) {
            this.zzbo.zza(labelValueRow);
            return this;
        }

        public final Builder setInfoModuleDataShowLastUpdateTime(boolean bl) {
            this.zzbo.zza(bl);
            return this;
        }

        public final Builder addImageModuleDataMainImageUris(Collection<UriData> collection) {
            this.zzbo.zzd(collection);
            return this;
        }

        public final Builder addImageModuleDataMainImageUri(UriData uriData) {
            this.zzbo.zza(uriData);
            return this;
        }

        public final Builder addTextModulesData(Collection<TextModuleData> collection) {
            this.zzbo.zze(collection);
            return this;
        }

        public final Builder addTextModuleData(TextModuleData textModuleData) {
            this.zzbo.zza(textModuleData);
            return this;
        }

        public final Builder addLinksModuleDataUris(Collection<UriData> collection) {
            this.zzbo.zzf(collection);
            return this;
        }

        public final Builder addLinksModuleDataUri(UriData uriData) {
            this.zzbo.zzb(uriData);
            return this;
        }

        public final OfferWalletObject build() {
            OfferWalletObject.this.zzbh = this.zzbo.zzf();
            return OfferWalletObject.this;
        }

        /* synthetic */ Builder(zzr zzr2) {
            this();
        }
    }
}

