/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.ArrayUtils;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.wallet.wobs.LabelValueRow;
import com.google.android.gms.wallet.wobs.LoyaltyPoints;
import com.google.android.gms.wallet.wobs.TextModuleData;
import com.google.android.gms.wallet.wobs.TimeInterval;
import com.google.android.gms.wallet.wobs.UriData;
import com.google.android.gms.wallet.wobs.WalletObjectMessage;
import com.google.android.gms.wallet.zzo;
import com.google.android.gms.wallet.zzp;
import java.util.ArrayList;
import java.util.Collection;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LoyaltyWalletObjectCreator")
public final class LoyaltyWalletObject
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<LoyaltyWalletObject> CREATOR = new zzp();
    @SafeParcelable.Field(id=2)
    String zzby;
    @SafeParcelable.Field(id=3)
    String zzbz;
    @SafeParcelable.Field(id=4)
    String zzca;
    @SafeParcelable.Field(id=5)
    String zzcb;
    @SafeParcelable.Field(id=6)
    String zzcc;
    @SafeParcelable.Field(id=7)
    String zzcd;
    @SafeParcelable.Field(id=8)
    String zzce;
    @SafeParcelable.Field(id=9)
    String zzcf;
    @Deprecated
    @SafeParcelable.Field(id=10)
    String zzcg;
    @SafeParcelable.Field(id=11)
    String zzch;
    @SafeParcelable.Field(id=12)
    int state;
    @SafeParcelable.Field(id=13, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<WalletObjectMessage> zzci;
    @SafeParcelable.Field(id=14)
    TimeInterval zzcj;
    @SafeParcelable.Field(id=15, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<LatLng> zzck;
    @Deprecated
    @SafeParcelable.Field(id=16)
    String zzcl;
    @Deprecated
    @SafeParcelable.Field(id=17)
    String zzcm;
    @SafeParcelable.Field(id=18, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<LabelValueRow> zzcn;
    @SafeParcelable.Field(id=19)
    boolean zzco;
    @SafeParcelable.Field(id=20, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<UriData> zzcp;
    @SafeParcelable.Field(id=21, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<TextModuleData> zzcq;
    @SafeParcelable.Field(id=22, defaultValueUnchecked="com.google.android.gms.common.util.ArrayUtils.newArrayList()")
    ArrayList<UriData> zzcr;
    @SafeParcelable.Field(id=23)
    LoyaltyPoints zzcs;

    public static Builder newBuilder() {
        return new LoyaltyWalletObject().new Builder(null);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LoyaltyWalletObject loyaltyWalletObject = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)loyaltyWalletObject.zzby, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)loyaltyWalletObject.zzbz, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)loyaltyWalletObject.zzca, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)loyaltyWalletObject.zzcb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)loyaltyWalletObject.zzcc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)loyaltyWalletObject.zzcd, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)8, (String)loyaltyWalletObject.zzce, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)loyaltyWalletObject.zzcf, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)loyaltyWalletObject.zzcg, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)11, (String)loyaltyWalletObject.zzch, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)12, (int)loyaltyWalletObject.state);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)13, loyaltyWalletObject.zzci, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)14, (Parcelable)loyaltyWalletObject.zzcj, (int)n, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)15, loyaltyWalletObject.zzck, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)16, (String)loyaltyWalletObject.zzcl, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)17, (String)loyaltyWalletObject.zzcm, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)18, loyaltyWalletObject.zzcn, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)19, (boolean)loyaltyWalletObject.zzco);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)20, loyaltyWalletObject.zzcp, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)21, loyaltyWalletObject.zzcq, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)22, loyaltyWalletObject.zzcr, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)23, (Parcelable)loyaltyWalletObject.zzcs, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Constructor
    LoyaltyWalletObject(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) String string5, @SafeParcelable.Param(id=7) String string6, @SafeParcelable.Param(id=8) String string7, @SafeParcelable.Param(id=9) String string8, @SafeParcelable.Param(id=10) String string9, @SafeParcelable.Param(id=11) String string10, @SafeParcelable.Param(id=12) int n, @SafeParcelable.Param(id=13) ArrayList<WalletObjectMessage> arrayList, @SafeParcelable.Param(id=14) TimeInterval timeInterval, @SafeParcelable.Param(id=15) ArrayList<LatLng> arrayList2, @SafeParcelable.Param(id=16) String string11, @SafeParcelable.Param(id=17) String string12, @SafeParcelable.Param(id=18) ArrayList<LabelValueRow> arrayList3, @SafeParcelable.Param(id=19) boolean bl, @SafeParcelable.Param(id=20) ArrayList<UriData> arrayList4, @SafeParcelable.Param(id=21) ArrayList<TextModuleData> arrayList5, @SafeParcelable.Param(id=22) ArrayList<UriData> arrayList6, @SafeParcelable.Param(id=23) LoyaltyPoints loyaltyPoints) {
        this.zzby = string;
        this.zzbz = string2;
        this.zzca = string3;
        this.zzcb = string4;
        this.zzcc = string5;
        this.zzcd = string6;
        this.zzce = string7;
        this.zzcf = string8;
        this.zzcg = string9;
        this.zzch = string10;
        this.state = n;
        this.zzci = arrayList;
        this.zzcj = timeInterval;
        this.zzck = arrayList2;
        this.zzcl = string11;
        this.zzcm = string12;
        this.zzcn = arrayList3;
        this.zzco = bl;
        this.zzcp = arrayList4;
        this.zzcq = arrayList5;
        this.zzcr = arrayList6;
        this.zzcs = loyaltyPoints;
    }

    LoyaltyWalletObject() {
        this.zzci = ArrayUtils.newArrayList();
        this.zzck = ArrayUtils.newArrayList();
        this.zzcn = ArrayUtils.newArrayList();
        this.zzcp = ArrayUtils.newArrayList();
        this.zzcq = ArrayUtils.newArrayList();
        this.zzcr = ArrayUtils.newArrayList();
    }

    public final String getId() {
        return this.zzby;
    }

    public final String getAccountId() {
        return this.zzbz;
    }

    public final String getIssuerName() {
        return this.zzca;
    }

    public final String getProgramName() {
        return this.zzcb;
    }

    public final String getAccountName() {
        return this.zzcc;
    }

    public final String getBarcodeAlternateText() {
        return this.zzcd;
    }

    public final String getBarcodeType() {
        return this.zzce;
    }

    public final String getBarcodeValue() {
        return this.zzcf;
    }

    @Deprecated
    public final String getBarcodeLabel() {
        return this.zzcg;
    }

    public final String getClassId() {
        return this.zzch;
    }

    public final int getState() {
        return this.state;
    }

    public final ArrayList<WalletObjectMessage> getMessages() {
        return this.zzci;
    }

    public final TimeInterval getValidTimeInterval() {
        return this.zzcj;
    }

    public final ArrayList<LatLng> getLocations() {
        return this.zzck;
    }

    @Deprecated
    public final String getInfoModuleDataHexFontColor() {
        return this.zzcl;
    }

    @Deprecated
    public final String getInfoModuleDataHexBackgroundColor() {
        return this.zzcm;
    }

    public final ArrayList<LabelValueRow> getInfoModuleDataLabelValueRows() {
        return this.zzcn;
    }

    public final boolean getInfoModuleDataShowLastUpdateTime() {
        return this.zzco;
    }

    public final ArrayList<UriData> getImageModuleDataMainImageUris() {
        return this.zzcp;
    }

    public final ArrayList<TextModuleData> getTextModulesData() {
        return this.zzcq;
    }

    public final ArrayList<UriData> getLinksModuleDataUris() {
        return this.zzcr;
    }

    public final LoyaltyPoints getLoyaltyPoints() {
        return this.zzcs;
    }

    public final class Builder {
        private Builder() {
        }

        public final Builder setId(String string) {
            LoyaltyWalletObject.this.zzby = string;
            return this;
        }

        public final Builder setAccountId(String string) {
            LoyaltyWalletObject.this.zzbz = string;
            return this;
        }

        public final Builder setIssuerName(String string) {
            LoyaltyWalletObject.this.zzca = string;
            return this;
        }

        public final Builder setProgramName(String string) {
            LoyaltyWalletObject.this.zzcb = string;
            return this;
        }

        public final Builder setAccountName(String string) {
            LoyaltyWalletObject.this.zzcc = string;
            return this;
        }

        public final Builder setBarcodeAlternateText(String string) {
            LoyaltyWalletObject.this.zzcd = string;
            return this;
        }

        public final Builder setBarcodeType(String string) {
            LoyaltyWalletObject.this.zzce = string;
            return this;
        }

        public final Builder setBarcodeValue(String string) {
            LoyaltyWalletObject.this.zzcf = string;
            return this;
        }

        @Deprecated
        public final Builder setBarcodeLabel(String string) {
            LoyaltyWalletObject.this.zzcg = string;
            return this;
        }

        public final Builder setClassId(String string) {
            LoyaltyWalletObject.this.zzch = string;
            return this;
        }

        public final Builder setState(int n) {
            LoyaltyWalletObject.this.state = n;
            return this;
        }

        public final Builder addMessages(Collection<WalletObjectMessage> collection) {
            LoyaltyWalletObject.this.zzci.addAll(collection);
            return this;
        }

        public final Builder addMessage(WalletObjectMessage walletObjectMessage) {
            LoyaltyWalletObject.this.zzci.add(walletObjectMessage);
            return this;
        }

        public final Builder setValidTimeInterval(TimeInterval timeInterval) {
            LoyaltyWalletObject.this.zzcj = timeInterval;
            return this;
        }

        public final Builder addLocations(Collection<LatLng> collection) {
            LoyaltyWalletObject.this.zzck.addAll(collection);
            return this;
        }

        public final Builder addLocation(LatLng latLng) {
            LoyaltyWalletObject.this.zzck.add(latLng);
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexFontColor(String string) {
            LoyaltyWalletObject.this.zzcl = string;
            return this;
        }

        @Deprecated
        public final Builder setInfoModuleDataHexBackgroundColor(String string) {
            LoyaltyWalletObject.this.zzcm = string;
            return this;
        }

        public final Builder addInfoModuleDataLabelValueRows(Collection<LabelValueRow> collection) {
            LoyaltyWalletObject.this.zzcn.addAll(collection);
            return this;
        }

        public final Builder addInfoModuleDataLabeValueRow(LabelValueRow labelValueRow) {
            LoyaltyWalletObject.this.zzcn.add(labelValueRow);
            return this;
        }

        public final Builder setInfoModuleDataShowLastUpdateTime(boolean bl) {
            LoyaltyWalletObject.this.zzco = bl;
            return this;
        }

        public final Builder addImageModuleDataMainImageUris(Collection<UriData> collection) {
            LoyaltyWalletObject.this.zzcp.addAll(collection);
            return this;
        }

        public final Builder addImageModuleDataMainImageUri(UriData uriData) {
            LoyaltyWalletObject.this.zzcp.add(uriData);
            return this;
        }

        public final Builder addTextModulesData(Collection<TextModuleData> collection) {
            LoyaltyWalletObject.this.zzcq.addAll(collection);
            return this;
        }

        public final Builder addTextModuleData(TextModuleData textModuleData) {
            LoyaltyWalletObject.this.zzcq.add(textModuleData);
            return this;
        }

        public final Builder addLinksModuleDataUris(Collection<UriData> collection) {
            LoyaltyWalletObject.this.zzcr.addAll(collection);
            return this;
        }

        public final Builder addLinksModuleDataUri(UriData uriData) {
            LoyaltyWalletObject.this.zzcr.add(uriData);
            return this;
        }

        public final Builder setLoyaltyPoints(LoyaltyPoints loyaltyPoints) {
            LoyaltyWalletObject.this.zzcs = loyaltyPoints;
            return this;
        }

        public final LoyaltyWalletObject build() {
            return LoyaltyWalletObject.this;
        }

        /* synthetic */ Builder(zzo zzo2) {
            this();
        }
    }
}

